/*
 * Decompiled with CFR 0.152.
 */
package rsp.util.logging;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rsp.util.logging.Log;

public final class Slf4jLogReporting
implements Log.Reporting {
    private final Logger logger;
    private final Log traceLog;
    private final Log debugLog;
    private final Log infoLog;
    private final Log warnLog;
    private final Log errorLog;

    public Slf4jLogReporting(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.traceLog = new Log(){

            @Override
            public void log(String message) {
                Slf4jLogReporting.this.logger.trace(message);
            }

            @Override
            public void log(String message, Throwable ex) {
                Slf4jLogReporting.this.logger.trace(message, ex);
            }
        };
        this.debugLog = new Log(){

            @Override
            public void log(String message) {
                Slf4jLogReporting.this.logger.debug(message);
            }

            @Override
            public void log(String message, Throwable ex) {
                Slf4jLogReporting.this.logger.debug(message, ex);
            }
        };
        this.infoLog = new Log(){

            @Override
            public void log(String message) {
                Slf4jLogReporting.this.logger.info(message);
            }

            @Override
            public void log(String message, Throwable ex) {
                Slf4jLogReporting.this.logger.info(message, ex);
            }
        };
        this.warnLog = new Log(){

            @Override
            public void log(String message) {
                Slf4jLogReporting.this.logger.warn(message);
            }

            @Override
            public void log(String message, Throwable ex) {
                Slf4jLogReporting.this.logger.warn(message, ex);
            }
        };
        this.errorLog = new Log(){

            @Override
            public void log(String message) {
                Slf4jLogReporting.this.logger.error(message);
            }

            @Override
            public void log(String message, Throwable ex) {
                Slf4jLogReporting.this.logger.error(message, ex);
            }
        };
    }

    @Override
    public void trace(Consumer<Log> logConsumer) {
        if (this.logger.isTraceEnabled()) {
            logConsumer.accept(this.traceLog);
        }
    }

    @Override
    public void debug(Consumer<Log> logConsumer) {
        if (this.logger.isDebugEnabled()) {
            logConsumer.accept(this.debugLog);
        }
    }

    @Override
    public void info(Consumer<Log> logConsumer) {
        if (this.logger.isInfoEnabled()) {
            logConsumer.accept(this.infoLog);
        }
    }

    @Override
    public void warn(Consumer<Log> logConsumer) {
        if (this.logger.isWarnEnabled()) {
            logConsumer.accept(this.warnLog);
        }
    }

    @Override
    public void error(Consumer<Log> logConsumer) {
        if (this.logger.isErrorEnabled()) {
            logConsumer.accept(this.errorLog);
        }
    }
}

