/*
 * Decompiled with CFR 0.152.
 */
package rsp.util.logging;

import java.util.function.Consumer;
import rsp.util.ExceptionsUtils;

public interface Log {
    public void log(String var1);

    public void log(String var1, Throwable var2);

    public static class Default
    implements Reporting {
        private final Level level;
        private final Log traceLog;
        private final Log debugLog;
        private final Log infoLog;
        private final Log warnLog;
        private final Log errorLog;

        public Default(Level level, Format format, Consumer<String> out) {
            this.level = level;
            this.traceLog = new LogImpl(Level.TRACE, format, out);
            this.debugLog = new LogImpl(Level.DEBUG, format, out);
            this.infoLog = new LogImpl(Level.INFO, format, out);
            this.warnLog = new LogImpl(Level.WARN, format, out);
            this.errorLog = new LogImpl(Level.ERROR, format, out);
        }

        @Override
        public void trace(Consumer<Log> logConsumer) {
            if (this.level == Level.TRACE) {
                logConsumer.accept(this.traceLog);
            }
        }

        @Override
        public void debug(Consumer<Log> logConsumer) {
            if (this.level == Level.TRACE || this.level == Level.DEBUG) {
                logConsumer.accept(this.debugLog);
            }
        }

        @Override
        public void info(Consumer<Log> logConsumer) {
            if (this.level == Level.TRACE || this.level == Level.DEBUG || this.level == Level.INFO) {
                logConsumer.accept(this.infoLog);
            }
        }

        @Override
        public void warn(Consumer<Log> logConsumer) {
            if (this.level == Level.TRACE || this.level == Level.DEBUG || this.level == Level.INFO || this.level == Level.WARN) {
                logConsumer.accept(this.warnLog);
            }
        }

        @Override
        public void error(Consumer<Log> logConsumer) {
            if (this.level == Level.TRACE || this.level == Level.DEBUG || this.level == Level.INFO || this.level == Level.WARN || this.level == Level.ERROR) {
                logConsumer.accept(this.errorLog);
            }
        }

        private static class LogImpl
        implements Log {
            private final Level level;
            private final Format format;
            private final Consumer<String> out;

            private LogImpl(Level level, Format format, Consumer<String> out) {
                this.level = level;
                this.format = format;
                this.out = out;
            }

            @Override
            public void log(String message) {
                this.out.accept(this.format.format(this.level, message));
            }

            @Override
            public void log(String message, Throwable cause) {
                this.out.accept(this.format.format(this.level, message, cause));
            }
        }
    }

    public static class SimpleFormat
    implements Format {
        @Override
        public String format(Level level, String message) {
            return "[" + level.name() + "] " + message;
        }

        @Override
        public String format(Level level, String message, Throwable ex) {
            return "[" + level.name() + "] " + message + "\nException: " + ex.getMessage() + "\n" + ExceptionsUtils.stackTraceToString(ex);
        }
    }

    public static interface Reporting {
        public void trace(Consumer<Log> var1);

        public void debug(Consumer<Log> var1);

        public void info(Consumer<Log> var1);

        public void warn(Consumer<Log> var1);

        public void error(Consumer<Log> var1);
    }

    public static interface Format {
        public String format(Level var1, String var2);

        public String format(Level var1, String var2, Throwable var3);
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF;

    }
}

