/*
 * Decompiled with CFR 0.152.
 */
package rsp.util.json;

public final class JsonUtils {
    public static String unescape(String s) {
        int charsConsumed;
        StringBuilder sb = new StringBuilder();
        int len = s.length() - 1;
        block10: for (int i = 0; i < len; i += charsConsumed) {
            char c = s.charAt(i);
            charsConsumed = 0;
            if (c != '\\') {
                charsConsumed = 1;
                sb.append(c);
                continue;
            }
            charsConsumed = 2;
            switch (s.charAt(i + 1)) {
                case '\\': {
                    sb.append('\\');
                    continue block10;
                }
                case '\"': {
                    sb.append('\"');
                    continue block10;
                }
                case 'b': {
                    sb.append('\b');
                    continue block10;
                }
                case 'f': {
                    sb.append('\f');
                    continue block10;
                }
                case 'n': {
                    sb.append('\n');
                    continue block10;
                }
                case 'r': {
                    sb.append('\r');
                    continue block10;
                }
                case 't': {
                    sb.append('\t');
                    continue block10;
                }
                case 'u': {
                    String code = s.substring(i + 2, i + 6);
                    charsConsumed = 6;
                    sb.append((char)Integer.parseInt(code, 16));
                }
            }
        }
        return sb.toString();
    }

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block9: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

