/*
 * Decompiled with CFR 0.152.
 */
package rsp.util.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import rsp.util.json.JsonDataType;

public class JsonSimple {
    public static JsonDataType convertToJsonType(Object j) {
        if (j == null) {
            return JsonDataType.Null.INSTANCE;
        }
        if (j instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)j;
            Set entrySet = jsonObject.entrySet();
            HashMap<String, JsonDataType> m = new HashMap<String, JsonDataType>();
            for (Map.Entry entry : entrySet) {
                m.put((String)entry.getKey(), JsonSimple.convertToJsonType(entry.getValue()));
            }
            return new JsonDataType.Object(Collections.unmodifiableMap(m));
        }
        if (j instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)j;
            ArrayList<JsonDataType> a = new ArrayList<JsonDataType>();
            for (Object item : jsonArray) {
                a.add(JsonSimple.convertToJsonType(item));
            }
            return new JsonDataType.Array(a.toArray(new JsonDataType[0]));
        }
        if (j instanceof String) {
            return new JsonDataType.String((String)j);
        }
        if (j instanceof Boolean) {
            return new JsonDataType.Boolean((Boolean)j);
        }
        if (j instanceof Long) {
            return new JsonDataType.Number((Long)j);
        }
        if (j instanceof Integer) {
            return new JsonDataType.Number((Integer)j);
        }
        if (j instanceof Double) {
            return new JsonDataType.Number((Double)j);
        }
        if (j instanceof Float) {
            return new JsonDataType.Number(((Float)j).floatValue());
        }
        throw new IllegalStateException("Unsupported json-simple data type: " + j.getClass().getName());
    }
}

