/*
 * Decompiled with CFR 0.152.
 */
package rsp.util.json;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface JsonDataType {
    default public java.lang.String toStringValue() {
        return this.toString();
    }

    public static final class Null
    implements JsonDataType {
        public static Null INSTANCE = new Null();

        private Null() {
        }

        public java.lang.String toString() {
            return "null";
        }
    }

    public static final class Array
    implements JsonDataType {
        private final JsonDataType[] items;

        public Array(JsonDataType ... items) {
            this.items = items;
        }

        public JsonDataType[] items() {
            return this.items;
        }

        public java.lang.String toString() {
            return "[" + java.lang.String.join((CharSequence)",", Arrays.stream(this.items).map(JsonDataType::toStringValue).collect(Collectors.toList())) + "]";
        }

        public boolean equals(java.lang.Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Array array = (Array)o;
            return Arrays.equals(this.items, array.items);
        }

        public int hashCode() {
            return Arrays.hashCode(this.items);
        }
    }

    public static final class Object
    implements JsonDataType {
        public static final Object EMPTY = new Object(Collections.emptyMap());
        private final Map<java.lang.String, JsonDataType> values;

        public Object(Map<java.lang.String, JsonDataType> values) {
            this.values = values;
        }

        public Object() {
            this(Map.of());
        }

        public Optional<JsonDataType> value(java.lang.String name) {
            return Optional.ofNullable(this.values.get(name));
        }

        public Set<java.lang.String> keys() {
            return this.values.keySet();
        }

        public java.lang.String toString() {
            return "{" + java.lang.String.join((CharSequence)",", this.values.entrySet().stream().map(e -> "\"" + (java.lang.String)e.getKey() + "\": \"" + ((JsonDataType)e.getValue()).toStringValue()).collect(Collectors.toList())) + "}";
        }

        public boolean equals(java.lang.Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Object object = (Object)o;
            return Objects.equals(this.values, object.values);
        }

        public int hashCode() {
            return Objects.hash(this.values);
        }
    }

    public static final class String
    implements JsonDataType {
        private final java.lang.String value;

        public String(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public java.lang.String toString() {
            return this.value;
        }

        @Override
        public java.lang.String toStringValue() {
            return "\"" + this.toString() + "\"";
        }

        public boolean equals(java.lang.Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            String string = (String)o;
            return Objects.equals(this.value, string.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static final class Number
    implements JsonDataType {
        private final java.lang.Number value;

        public Number(long value) {
            this.value = value;
        }

        public Number(int value) {
            this.value = (long)value;
        }

        public Number(byte value) {
            this.value = (long)value;
        }

        public Number(short value) {
            this.value = (long)value;
        }

        public Number(float value) {
            this.value = (double)value;
        }

        public Number(double value) {
            this.value = value;
        }

        public boolean isFractional() {
            return this.value instanceof Double;
        }

        public long asLong() {
            return (Long)this.value;
        }

        public double asDouble() {
            return (Double)this.value;
        }

        public java.lang.Number value() {
            return this.value;
        }

        public java.lang.String toString() {
            return this.value.toString();
        }

        public boolean equals(java.lang.Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Number number = (Number)o;
            return Objects.equals(this.value, number.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static final class Boolean
    implements JsonDataType {
        private final boolean value;

        public Boolean(boolean value) {
            this.value = value;
        }

        public boolean value() {
            return this.value;
        }

        public java.lang.String toString() {
            return java.lang.Boolean.toString(this.value);
        }

        public boolean equals(java.lang.Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Boolean aBoolean = (Boolean)o;
            return this.value == aBoolean.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

