/*
 * Decompiled with CFR 0.152.
 */
package rsp.util.data;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class Either<L, R> {
    private Either() {
    }

    public static <L, R> Either<L, R> left(L value) {
        return new Left(Objects.requireNonNull(value));
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(Objects.requireNonNull(value));
    }

    public abstract <LL, RR> Either<LL, RR> map(Function<L, LL> var1, Function<R, RR> var2);

    public abstract <LL, RR> Either<LL, RR> flatMap(Function<L, Either<LL, RR>> var1, Function<R, Either<LL, RR>> var2);

    public abstract void on(Consumer<L> var1, Consumer<R> var2);

    private static class Right<L, R>
    extends Either<L, R> {
        private final R value;

        public Right(R value) {
            this.value = value;
        }

        @Override
        public <LL, RR> Either<LL, RR> map(Function<L, LL> funLeft, Function<R, RR> funRight) {
            return Right.right(funRight.apply(this.value));
        }

        @Override
        public <LL, RR> Either<LL, RR> flatMap(Function<L, Either<LL, RR>> funLeft, Function<R, Either<LL, RR>> funRight) {
            return funRight.apply(this.value);
        }

        @Override
        public void on(Consumer<L> left, Consumer<R> right) {
            right.accept(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Right right = (Right)o;
            return Objects.equals(this.value, right.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Right{value=" + this.value + "}";
        }
    }

    private static class Left<L, R>
    extends Either<L, R> {
        private final L value;

        public Left(L value) {
            this.value = value;
        }

        @Override
        public <LL, RR> Either<LL, RR> map(Function<L, LL> funLeft, Function<R, RR> funRight) {
            return Left.left(funLeft.apply(this.value));
        }

        @Override
        public <LL, RR> Either<LL, RR> flatMap(Function<L, Either<LL, RR>> funLeft, Function<R, Either<LL, RR>> funRight) {
            return funLeft.apply(this.value);
        }

        @Override
        public void on(Consumer<L> left, Consumer<R> right) {
            left.accept(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Left left = (Left)o;
            return Objects.equals(this.value, left.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Left{value=" + this.value + "}";
        }
    }
}

