/*
 * Decompiled with CFR 0.152.
 */
package rsp.util;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class StreamUtils {
    public static <T> Stream<T> iterate(Iterator<? extends T> iterator) {
        int characteristics = 1040;
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1040), false);
    }

    public static <L, R, T> Stream<T> zip(Stream<L> leftStream, Stream<R> rightStream, final BiFunction<L, R, T> combiner) {
        final Spliterator lefts = leftStream.spliterator();
        final Spliterator rights = rightStream.spliterator();
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.min(lefts.estimateSize(), rights.estimateSize()), lefts.characteristics() & rights.characteristics()){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                return lefts.tryAdvance(left -> rights.tryAdvance(right -> action.accept((Object)combiner.apply(left, right))));
            }
        }, leftStream.isParallel() || rightStream.isParallel());
    }

    public static <T> Stream<Map.Entry<Integer, T>> zipWithIndex(final Stream<? extends T> stream) {
        return StreamUtils.iterate(new Iterator<Map.Entry<Integer, T>>(){
            private final Iterator<? extends T> streamIterator;
            private int index;
            {
                this.streamIterator = stream.iterator();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.streamIterator.hasNext();
            }

            @Override
            public Map.Entry<Integer, T> next() {
                return new AbstractMap.SimpleImmutableEntry(this.index++, this.streamIterator.next());
            }
        });
    }

    public static <T, R> Stream<R> mapWithIndex(Stream<? extends T> stream, BiFunction<Integer, ? super T, ? extends R> mapper) {
        return StreamUtils.zipWithIndex(stream).map(entry -> mapper.apply((Integer)entry.getKey(), (Object)entry.getValue()));
    }

    public static <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> listOfCompletableFutures) {
        return CompletableFuture.allOf((CompletableFuture[])listOfCompletableFutures.toArray(CompletableFuture[]::new)).thenApply(v -> listOfCompletableFutures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }
}

