/*
 * Decompiled with CFR 0.152.
 */
package rsp.util;

import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class JsCompiler {
    public static void main(String[] args) throws IOException {
        if (JsCompiler.assembleJs((File)new File((String)args[0]), (File)new File((String)args[1]), (String)args[2]).errors.size() > 0) {
            System.exit(1);
        }
    }

    public static Result assembleJs(File sourceDir, File targetDir, String baseName) throws IOException {
        System.out.println("Assembling ES6 sources using Google Closure Compiler");
        if (!sourceDir.isDirectory()) {
            throw new IllegalStateException(sourceDir.getAbsolutePath() + " sources directory expected");
        }
        if (!targetDir.isDirectory()) {
            throw new IllegalStateException(sourceDir.getAbsolutePath() + " target directory expected");
        }
        File sourceOutputFile = new File(targetDir, baseName + ".min.js");
        File sourceMapOutputFile = new File(targetDir, baseName + ".min.js.map");
        Compiler compiler = new Compiler();
        List externs = AbstractCommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)CompilerOptions.Environment.BROWSER);
        Result result = compiler.compile(externs, JsCompiler.inputs(sourceDir), JsCompiler.options(sourceDir, sourceMapOutputFile));
        String compiledJs = compiler.toSource();
        StringBuilder sourceMapStringBuilder = new StringBuilder();
        result.sourceMap.appendTo((Appendable)sourceMapStringBuilder, sourceMapOutputFile.getName());
        Files.writeString(sourceOutputFile.toPath(), (CharSequence)("(function(){" + compiledJs + "}).call(this);\n//# sourceMappingURL=" + baseName + ".min.js.map\n"), new OpenOption[0]);
        Files.writeString(sourceMapOutputFile.toPath(), (CharSequence)sourceMapStringBuilder.toString(), new OpenOption[0]);
        return result;
    }

    private static List<SourceFile> inputs(File sourceDir) {
        return Arrays.stream(sourceDir.listFiles()).map(file -> {
            String path = file.getAbsolutePath();
            Charset charset = StandardCharsets.UTF_8;
            return SourceFile.fromFile((String)path, (Charset)charset);
        }).collect(Collectors.toList());
    }

    private static CompilerOptions options(File source, File sourceMapOutputFile) {
        CompilerOptions options = new CompilerOptions();
        options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_2015);
        options.setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT5_STRICT);
        options.setSourceMapIncludeSourcesContent(true);
        options.setSourceMapLocationMappings(List.of(new SourceMap.PrefixLocationMapping(source.getAbsolutePath(), "RSP/es6")));
        options.setSourceMapOutputPath(sourceMapOutputFile.getName());
        options.setEnvironment(CompilerOptions.Environment.BROWSER);
        CompilationLevel.ADVANCED_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        return options;
    }
}

