/*
 * Decompiled with CFR 0.152.
 */
package rsp.state;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import rsp.state.CompletableFutureConsumer;
import rsp.state.FunctionConsumer;

public interface UseState<S>
extends Supplier<S>,
Consumer<S>,
CompletableFutureConsumer<S>,
FunctionConsumer<S> {
    default public boolean isInstanceOf(Class<? extends S> clazz) {
        return clazz.isAssignableFrom(this.get().getClass());
    }

    default public <T extends S> UseState<T> cast(Class<T> clazz) {
        if (this.isInstanceOf(clazz)) {
            return UseState.readWrite(() -> this.get(), v -> this.accept(v));
        }
        throw new ClassCastException("Unable cast the underlying type " + this.get().getClass() + " to " + clazz);
    }

    public static <S> UseState<S> readWriteInCompletableFuture(final Supplier<S> supplier, final CompletableFutureConsumer<S> completableFutureConsumer) {
        return new UseState<S>(){

            @Override
            public void accept(S s) {
                this.accept(CompletableFuture.completedFuture(s));
            }

            @Override
            public S get() {
                return supplier.get();
            }

            @Override
            public void accept(CompletableFuture<S> cf) {
                completableFutureConsumer.accept(cf);
            }

            @Override
            public void accept(Function<S, S> f) {
                this.accept((CompletableFuture)new CompletableFuture().thenApply(f));
            }

            @Override
            public void acceptOptional(Function<S, Optional<S>> function) {
                function.apply(supplier.get()).ifPresent(s -> this.accept((S)s));
            }
        };
    }

    public static <S> UseState<S> readWriteInFunction(final Supplier<S> supplier, final FunctionConsumer<S> functionConsumer) {
        return new UseState<S>(){

            @Override
            public void accept(S s) {
                functionConsumer.accept((S p) -> s);
            }

            @Override
            public S get() {
                return supplier.get();
            }

            @Override
            public void accept(CompletableFuture<S> completableFuture) {
                completableFuture.thenAccept(s -> this.accept((S)s));
            }

            @Override
            public void accept(Function<S, S> f) {
                functionConsumer.accept(f);
            }

            @Override
            public void acceptOptional(Function<S, Optional<S>> function) {
                function.apply(this.get()).ifPresent(s -> functionConsumer.accept((S p) -> s));
            }
        };
    }

    public static <S> UseState<S> readWrite(final Supplier<S> supplier, final Consumer<S> consumer) {
        return new UseState<S>(){

            @Override
            public void accept(Function<S, S> function) {
                consumer.accept(function.apply(supplier.get()));
            }

            @Override
            public void acceptOptional(Function<S, Optional<S>> function) {
                function.apply(this.get()).ifPresent(s -> consumer.accept(s));
            }

            @Override
            public S get() {
                return supplier.get();
            }

            @Override
            public void accept(S s) {
                consumer.accept(s);
            }

            @Override
            public void accept(CompletableFuture<S> completableFuture) {
                completableFuture.thenAccept(s -> consumer.accept(s));
            }
        };
    }

    public static <S> UseState<S> readOnly(final Supplier<S> supplier) {
        return new UseState<S>(){

            @Override
            public S get() {
                return supplier.get();
            }

            @Override
            public void accept(S s) {
                throw new IllegalStateException("Not allowed for a read-only UseState instance");
            }

            @Override
            public void accept(CompletableFuture<S> completableFuture) {
                throw new IllegalStateException("Not allowed for a read-only UseState instance");
            }

            @Override
            public void accept(Function<S, S> function) {
                throw new IllegalStateException("Not allowed for a read-only UseState instance");
            }

            @Override
            public void acceptOptional(Function<S, Optional<S>> function) {
                throw new IllegalStateException("Not allowed for a read-only UseState instance");
            }
        };
    }

    public static UseState<Void> empty() {
        return new UseState<Void>(){

            @Override
            public Void get() {
                throw new IllegalStateException("Not allowed for the Void type");
            }

            @Override
            public void accept(Void s) {
                throw new IllegalStateException("Not allowed for the Void type");
            }

            @Override
            public void accept(CompletableFuture<Void> completableFuture) {
                throw new IllegalStateException("Not allowed for the Void type");
            }

            @Override
            public void accept(Function<Void, Void> function) {
                throw new IllegalStateException("Not allowed for the Void type");
            }

            @Override
            public void acceptOptional(Function<Void, Optional<Void>> function) {
                throw new IllegalStateException("Not allowed for the Void type");
            }
        };
    }
}

