/*
 * Decompiled with CFR 0.152.
 */
package rsp.server;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import rsp.dom.DefaultDomChangesPerformer;
import rsp.dom.Event;
import rsp.dom.VirtualDomPath;
import rsp.dom.XmlNs;
import rsp.server.OutMessages;
import rsp.util.json.JsonUtils;

public final class SerializeOutMessages
implements OutMessages {
    private static final int SET_RENDER_NUM = 0;
    private static final int CLEAN_ROOT = 1;
    private static final int LISTEN_EVENT = 2;
    private static final int EXTRACT_PROPERTY = 3;
    private static final int MODIFY_DOM = 4;
    private static final int FOCUS = 5;
    private static final int CHANGE_PAGE_URL = 6;
    private static final int UPLOAD_FORM = 7;
    private static final int RELOAD_CSS = 8;
    private static final int KEEP_ALIVE = 9;
    private static final int EVAL_JS = 10;
    private static final int EXTRACT_EVENT_DATA = 11;
    private static final int LIST_FILES = 12;
    private static final int UPLOAD_FILE = 13;
    private static final int REST_FORM = 14;
    private static final int FORGET_EVENT = 15;
    private static final int CREATE = 0;
    private static final int CREATE_TEXT = 1;
    private static final int REMOVE = 2;
    private static final int SET_ATTR = 3;
    private static final int REMOVE_ATTR = 4;
    private static final int SET_STYLE = 5;
    private static final int REMOVE_STYLE = 6;
    private static final int NO_EVENT_MODIFIER = 0;
    private static final int THROTTLE_EVENT_MODIFIER = 1;
    private static final int DEBOUNCE_EVENT_MODIFIER = 2;
    private static final int HREF_LOCATION_TYPE = 0;
    private static final int PATHNAME_LOCATION_TYPE = 1;
    private static final int HASH_LOCATION_TYPE = 2;
    private static final int SEARCH_LOCATION_TYPE = 3;
    private static final int PUSH_STATE_TYPE = 4;
    private final Consumer<String> messagesConsumer;

    public SerializeOutMessages(Consumer<String> messagesConsumer) {
        this.messagesConsumer = messagesConsumer;
    }

    @Override
    public void setRenderNum(int renderNum) {
        String message = this.addSquareBrackets(this.joinString(0, renderNum));
        this.messagesConsumer.accept(message);
    }

    @Override
    public void listenEvents(List<Event> events) {
        if (events.size() > 0) {
            String[] changes = (String[])events.stream().map(e -> this.joinString(this.quote(e.eventTarget.eventType), e.preventDefault, this.quote(e.eventTarget.elementPath.toString()), this.quote(SerializeOutMessages.modifierString(e.modifier)))).toArray(String[]::new);
            String message = this.addSquareBrackets(this.joinString(2, this.joinString(changes)));
            this.messagesConsumer.accept(message);
        }
    }

    @Override
    public void forgetEvent(String eventType, VirtualDomPath path) {
        String message = this.addSquareBrackets(this.joinString(15, this.quote(JsonUtils.escape(eventType)), this.quote(path.toString())));
        this.messagesConsumer.accept(message);
    }

    private static String modifierString(Event.Modifier eventModifier) {
        if (eventModifier instanceof Event.ThrottleModifier) {
            Event.ThrottleModifier m = (Event.ThrottleModifier)eventModifier;
            return "1:" + m.timeFrameMs;
        }
        if (eventModifier instanceof Event.DebounceModifier) {
            Event.DebounceModifier m = (Event.DebounceModifier)eventModifier;
            return "2:" + m.waitMs + ":" + m.immediate;
        }
        return Integer.toString(0);
    }

    @Override
    public void extractProperty(int descriptor, VirtualDomPath path, String name) {
        String message = this.addSquareBrackets(this.joinString(3, this.quote(descriptor), this.quote(path), this.quote(JsonUtils.escape(name))));
        this.messagesConsumer.accept(message);
    }

    @Override
    public void modifyDom(List<DefaultDomChangesPerformer.DomChange> domChanges) {
        if (domChanges.size() > 0) {
            String[] changes = (String[])domChanges.stream().map(this::modifyDomMessageBody).toArray(String[]::new);
            String message = this.addSquareBrackets(this.joinString(4, this.joinString(changes)));
            this.messagesConsumer.accept(message);
        }
    }

    @Override
    public void setHref(String path) {
        String message = this.addSquareBrackets(this.joinString(6, 0, this.quote(path)));
        this.messagesConsumer.accept(message);
    }

    @Override
    public void pushHistory(String path) {
        String message = this.addSquareBrackets(this.joinString(6, 4, this.quote(path)));
        this.messagesConsumer.accept(message);
    }

    private String modifyDomMessageBody(DefaultDomChangesPerformer.DomChange domChange) {
        if (domChange instanceof DefaultDomChangesPerformer.RemoveAttr) {
            DefaultDomChangesPerformer.RemoveAttr c = (DefaultDomChangesPerformer.RemoveAttr)domChange;
            return this.joinString(4, this.quote(c.path), this.xmlNsString(c.xmlNs), this.quote(JsonUtils.escape(c.name)), c.isProperty);
        }
        if (domChange instanceof DefaultDomChangesPerformer.RemoveStyle) {
            DefaultDomChangesPerformer.RemoveStyle c = (DefaultDomChangesPerformer.RemoveStyle)domChange;
            return this.joinString(6, this.quote(c.path), this.quote(JsonUtils.escape(c.name)), false);
        }
        if (domChange instanceof DefaultDomChangesPerformer.Remove) {
            DefaultDomChangesPerformer.Remove c = (DefaultDomChangesPerformer.Remove)domChange;
            return this.joinString(2, this.quote(c.parentPath), this.quote(c.path));
        }
        if (domChange instanceof DefaultDomChangesPerformer.SetAttr) {
            DefaultDomChangesPerformer.SetAttr c = (DefaultDomChangesPerformer.SetAttr)domChange;
            return this.joinString(3, this.quote(c.path), this.xmlNsString(c.xmlNs), this.quote(JsonUtils.escape(c.name)), this.quote(c.value), c.isProperty);
        }
        if (domChange instanceof DefaultDomChangesPerformer.SetStyle) {
            DefaultDomChangesPerformer.SetStyle c = (DefaultDomChangesPerformer.SetStyle)domChange;
            return this.joinString(5, this.quote(c.path), this.quote(JsonUtils.escape(c.name)), this.quote(JsonUtils.escape(c.value)));
        }
        if (domChange instanceof DefaultDomChangesPerformer.CreateText) {
            DefaultDomChangesPerformer.CreateText c = (DefaultDomChangesPerformer.CreateText)domChange;
            return this.joinString(1, this.quote(c.parentPath), this.quote(c.path), this.quote(JsonUtils.escape(c.text)));
        }
        if (domChange instanceof DefaultDomChangesPerformer.Create) {
            DefaultDomChangesPerformer.Create c = (DefaultDomChangesPerformer.Create)domChange;
            return this.joinString(0, this.quote(c.path.parent().get()), this.quote(c.path), this.xmlNsString(c.xmlNs), this.quote(JsonUtils.escape(c.tag)));
        }
        throw new IllegalStateException("Unsupported DomChange object type:" + domChange);
    }

    private String xmlNsString(XmlNs xmlNs) {
        return xmlNs.uri.equals(XmlNs.html.uri) ? "0" : this.quote(xmlNs.toString());
    }

    @Override
    public void evalJs(int descriptor, String js) {
        String message = this.addSquareBrackets(this.joinString(10, descriptor, this.quote(js)));
        this.messagesConsumer.accept(message);
    }

    private String joinString(String[] strings) {
        return String.join((CharSequence)",", strings);
    }

    private String joinString(Object ... objects) {
        return this.joinString((String[])Arrays.stream(objects).map(Object::toString).toArray(String[]::new));
    }

    private String quote(Object str) {
        return "\"" + str + "\"";
    }

    private String addSquareBrackets(String str) {
        return "[" + str + "]";
    }
}

