/*
 * Decompiled with CFR 0.152.
 */
package rsp.server;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import rsp.util.ArrayUtils;

public final class Path {
    public static final Path EMPTY_ABSOLUTE = new Path(true, new String[0]);
    public static final Path EMPTY_RELATIVE = new Path(false, new String[0]);
    public final boolean isAbsolute;
    public final String[] elements;

    public Path(boolean isAbsolute, String ... elements) {
        this.isAbsolute = isAbsolute;
        this.elements = elements;
    }

    public static Path absolute(String ... segments) {
        return new Path(true, segments);
    }

    public static Path relative(String ... segments) {
        return new Path(false, segments);
    }

    public static Path of(String str) {
        String trimmedStr = str.trim();
        String[] tokens = (String[])Arrays.stream(trimmedStr.split("/")).filter(s -> !s.isEmpty()).toArray(String[]::new);
        return new Path(trimmedStr.startsWith("/"), tokens);
    }

    public Path resolve(Path path) {
        if (path.isAbsolute) {
            return path;
        }
        return new Path(this.isAbsolute, ArrayUtils.concat(this.elements, path.elements));
    }

    public Path relativize(Path path) {
        return new Path(false, new String[0]);
    }

    public String get(int index) {
        if (index >= 0 && index < this.elements.length) {
            return this.elements[index];
        }
        throw new IllegalArgumentException("Path index: " + index + " , elements number: " + this.elements.length);
    }

    public int size() {
        return this.elements.length;
    }

    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        return this.isAbsolute == path.isAbsolute && Arrays.equals(this.elements, path.elements);
    }

    public int hashCode() {
        int result = Objects.hash(this.isAbsolute);
        result = 31 * result + Arrays.hashCode(this.elements);
        return result;
    }

    public Stream<String> stream() {
        return Arrays.stream(this.elements);
    }

    public String toString() {
        String elementsString = String.join((CharSequence)"/", this.elements);
        return this.isAbsolute ? "/" + elementsString : elementsString;
    }

    public Optional<String> last() {
        return this.elements.length > 0 ? Optional.of(this.elements[this.elements.length - 1]) : Optional.empty();
    }

    public boolean endsWith(String s) {
        return this.elements.length != 0 && this.elements[this.elements.length - 1].equals(s);
    }

    public boolean startsWith(String s) {
        return this.elements.length != 0 && this.elements[0].equals(s);
    }
}

