/*
 * Decompiled with CFR 0.152.
 */
package rsp.server;

import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import rsp.server.Path;

public final class HttpRequest {
    public final HttpMethod method;
    public final URI uri;
    public final String url;
    public final Path path;
    public final Function<String, Optional<String>> getQueryParam;
    public final Function<String, Optional<String>> getHeader;

    public HttpRequest(HttpMethod method, URI uri, String url, Path path, Function<String, Optional<String>> queryParam, Function<String, Optional<String>> getHeader) {
        this.method = method;
        this.uri = uri;
        this.url = url;
        this.path = path;
        this.getQueryParam = queryParam;
        this.getHeader = getHeader;
    }

    public HttpRequest(HttpMethod method, URI uri, String url, Path path) {
        this.method = method;
        this.uri = uri;
        this.url = url;
        this.path = path;
        this.getQueryParam = n -> Optional.empty();
        this.getHeader = n -> Optional.empty();
    }

    public Optional<String> cookie(String cookieName) {
        return this.getHeader.apply("Cookie").flatMap(headerValue -> Arrays.stream(headerValue.split(";")).map(String::trim).map(pairStr -> (String[])Arrays.stream(pairStr.split("=")).toArray(String[]::new)).filter(pair -> ((String[])pair).length == 2 && pair[0].equals(cookieName)).findFirst().map(pair -> pair[1]));
    }

    public Optional<String> deviceId() {
        return this.cookie("deviceId");
    }

    public Optional<String> queryParam(String name) {
        return this.getQueryParam.apply(name);
    }

    public Optional<String> header(String headerName) {
        return this.getHeader.apply(headerName);
    }

    public static enum HttpMethod {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        CONNECT,
        OPTIONS,
        TRACE,
        PATCH;

    }
}

