/*
 * Decompiled with CFR 0.152.
 */
package rsp.server;

import java.util.Objects;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import rsp.dom.VirtualDomPath;
import rsp.server.InMessages;
import rsp.util.data.Either;
import rsp.util.json.JsonDataType;
import rsp.util.json.JsonSimple;
import rsp.util.logging.Log;

public final class DeserializeInMessage {
    private final InMessages inMessages;
    private final Log.Reporting log;
    private static final int DOM_EVENT = 0;
    private static final int CUSTOM_CALLBACK = 1;
    private static final int EXTRACT_PROPERTY_RESPONSE = 2;
    private static final int HISTORY = 3;
    private static final int EVAL_JS_RESPONSE = 4;
    private static final int EXTRACT_EVENT_DATA_RESPONSE = 5;
    private static final int HEARTBEAT = 6;
    private static final int JSON_METADATA_DATA = 0;
    private static final int JSON_METADATA_UNDEFINED = 1;
    private static final int JSON_METADATA_FUNCTION = 2;
    private static final int JSON_METADATA_ERROR = 3;

    public DeserializeInMessage(InMessages inMessages, Log.Reporting log) {
        this.inMessages = inMessages;
        this.log = log;
    }

    public void parse(String message) {
        Objects.requireNonNull(message);
        JSONParser jsonParser = new JSONParser();
        try {
            JSONArray messageJson = (JSONArray)jsonParser.parse(message);
            int messageType = Math.toIntExact((Long)messageJson.get(0));
            switch (messageType) {
                case 0: {
                    this.parseDomEvent((String)messageJson.get(1), messageJson.get(2));
                    break;
                }
                case 2: {
                    this.parseExtractPropertyResponse((String)messageJson.get(1), messageJson.get(2));
                    break;
                }
                case 4: {
                    this.parseEvalJsResponse((String)messageJson.get(1), messageJson.size() > 2 ? messageJson.get(2) : "");
                    break;
                }
                case 6: {
                    this.heartBeat();
                }
            }
        }
        catch (Throwable ex) {
            this.log.error(l -> l.log("Incoming message parse exception", ex));
        }
    }

    private void parseExtractPropertyResponse(String metadata, Object value) {
        String[] tokens = metadata.split(":");
        int descriptorId = Integer.parseInt(tokens[0]);
        int jsonMetadata = Integer.parseInt(tokens[1]);
        Either<Throwable, JsonDataType> result = jsonMetadata == 0 ? Either.right(JsonSimple.convertToJsonType(value)) : Either.left(new RuntimeException("Property not found"));
        this.inMessages.handleExtractPropertyResponse(descriptorId, result);
    }

    private void parseEvalJsResponse(String metadata, Object value) {
        String[] tokens = metadata.split(":");
        this.inMessages.handleEvalJsResponse(Integer.parseInt(tokens[0]), JsonSimple.convertToJsonType(value));
    }

    private void parseDomEvent(String str, Object eventObject) {
        JsonDataType json = JsonSimple.convertToJsonType(eventObject);
        if (!(json instanceof JsonDataType.Object)) {
            throw new IllegalStateException("Unexpected type of an event object: " + eventObject.getClass().getName());
        }
        String[] tokens = str.split(":");
        this.inMessages.handleDomEvent(Integer.parseInt(tokens[0]), VirtualDomPath.of(tokens[1]), tokens[2], (JsonDataType.Object)JsonSimple.convertToJsonType(eventObject));
    }

    private void heartBeat() {
    }
}

