/*
 * Decompiled with CFR 0.152.
 */
package rsp.routing;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import rsp.routing.HttpRequestMatchFunction;
import rsp.routing.PathMatchFunction;
import rsp.routing.PathPattern;
import rsp.routing.Route;
import rsp.routing.Routes;
import rsp.server.HttpRequest;
import rsp.server.Path;
import rsp.util.TriFunction;

public final class RoutingDsl {
    @SafeVarargs
    public static <T, S> Route<T, S> concat(Route<T, S> ... routeDefinitions) {
        return new Routes<T, S>(routeDefinitions);
    }

    public static <S> Route<Path, S> path(String pathPattern, CompletableFuture<S> value) {
        PathPattern pp = PathPattern.of(pathPattern);
        return RoutingDsl.match(pp::match, new PathMatchFunction(pp, (p1, p2) -> value));
    }

    public static <S> Route<Path, S> path(String pathPattern, Function<String, CompletableFuture<S>> matchFun) {
        PathPattern pp = PathPattern.of(pathPattern);
        return RoutingDsl.match(pp::match, new PathMatchFunction(pp, (p1, p2) -> (CompletableFuture)matchFun.apply((String)p1)));
    }

    public static <S> Route<Path, S> path(String pathPattern, BiFunction<String, String, CompletableFuture<S>> matchFun) {
        PathPattern pp = PathPattern.of(pathPattern);
        return RoutingDsl.match(pp::match, new PathMatchFunction<S>(pp, matchFun));
    }

    public static <S> Route<HttpRequest, S> get(Function<HttpRequest, Route<Path, S>> subRoutes) {
        return req -> req.method.equals((Object)HttpRequest.HttpMethod.GET) ? (Optional)((Route)subRoutes.apply((HttpRequest)req)).apply(req.path) : Optional.empty();
    }

    public static <S> Route<HttpRequest, S> get(String pathPattern, Function<HttpRequest, CompletableFuture<S>> matchFun) {
        PathPattern pp = PathPattern.of(pathPattern);
        return RoutingDsl.match(req -> HttpRequest.HttpMethod.GET.equals((Object)req.method) && pp.match(req.path), new HttpRequestMatchFunction(pp, (req, p1, p2) -> (CompletableFuture)matchFun.apply((HttpRequest)req)));
    }

    public static <S> Route<HttpRequest, S> get(String pathPattern, BiFunction<HttpRequest, String, CompletableFuture<S>> matchFun) {
        PathPattern pp = PathPattern.of(pathPattern);
        return RoutingDsl.match(req -> HttpRequest.HttpMethod.GET.equals((Object)req.method) && pp.match(req.path), new HttpRequestMatchFunction(pp, (req, p1, p2) -> (CompletableFuture)matchFun.apply((HttpRequest)req, (String)p1)));
    }

    public static <S> Route<HttpRequest, S> get(String pathPattern, TriFunction<HttpRequest, String, String, CompletableFuture<S>> matchFun) {
        PathPattern pp = PathPattern.of(pathPattern);
        return RoutingDsl.match(req -> HttpRequest.HttpMethod.GET.equals((Object)req.method) && pp.match(req.path), new HttpRequestMatchFunction<S>(pp, matchFun));
    }

    public static <S> Route<HttpRequest, S> post(String pathPattern, Function<HttpRequest, CompletableFuture<S>> matchFun) {
        PathPattern pp = PathPattern.of(pathPattern);
        return RoutingDsl.match(req -> HttpRequest.HttpMethod.POST.equals((Object)req.method) && pp.match(req.path), new HttpRequestMatchFunction(pp, (req, p1, p2) -> (CompletableFuture)matchFun.apply((HttpRequest)req)));
    }

    public static <S> Route<HttpRequest, S> post(String pathPattern, BiFunction<String, HttpRequest, CompletableFuture<S>> matchFun) {
        PathPattern pp = PathPattern.of(pathPattern);
        return RoutingDsl.match(req -> HttpRequest.HttpMethod.POST.equals((Object)req.method) && pp.match(req.path), new HttpRequestMatchFunction(pp, (req, p1, p2) -> (CompletableFuture)matchFun.apply((String)p1, (HttpRequest)req)));
    }

    public static <S> Route<HttpRequest, S> post(String pathPattern, TriFunction<HttpRequest, String, String, CompletableFuture<S>> matchFun) {
        PathPattern pp = PathPattern.of(pathPattern);
        return RoutingDsl.match(req -> HttpRequest.HttpMethod.POST.equals((Object)req.method) && pp.match(req.path), new HttpRequestMatchFunction<S>(pp, matchFun));
    }

    public static <T, S> Route<T, S> match(Predicate<T> matchPredicate, Function<T, CompletableFuture<S>> matchFun) {
        return t -> matchPredicate.test(t) ? Optional.of((CompletableFuture)matchFun.apply(t)) : Optional.empty();
    }

    public static <S> Route<HttpRequest, S> any(S value) {
        return req -> Optional.of(CompletableFuture.completedFuture(value));
    }
}

