/*
 * Decompiled with CFR 0.152.
 */
package rsp.routing;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import rsp.routing.Route;

public final class Routes<T, S>
implements Route<T, S> {
    public final Route<T, S>[] routeDefinitions;

    @SafeVarargs
    public Routes(Route<T, S> ... routes) {
        this.routeDefinitions = routes;
    }

    @Override
    public Optional<CompletableFuture<? extends S>> apply(T request) {
        for (Route<T, S> routeDefinition : this.routeDefinitions) {
            Optional result = (Optional)routeDefinition.apply(request);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }
}

