/*
 * Decompiled with CFR 0.152.
 */
package rsp.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rsp.server.Path;
import rsp.util.data.Tuple2;

public final class PathPattern {
    public final List<String> patternSegments;
    public final int[] paramsIndexes;
    private final Map<Integer, Pattern> regexes;
    private static final Pattern FIND_REGEX = Pattern.compile("\\(.*\\)");

    private PathPattern(List<String> patternSegments, int[] paramsIndexes, Map<Integer, Pattern> regexes) {
        this.patternSegments = patternSegments;
        this.paramsIndexes = paramsIndexes;
        this.regexes = regexes;
    }

    public static PathPattern of(String pattern) {
        Tuple2<List<String>, Map<Integer, Pattern>> p = PathPattern.parse(pattern);
        return new PathPattern((List)p._1, PathPattern.paramsIndexes((List)p._1), (Map)p._2);
    }

    private static Tuple2<List<String>, Map<Integer, Pattern>> parse(String pattern) {
        String[] segments = (String[])Arrays.stream(pattern.split("/")).filter(s -> !s.isEmpty()).toArray(String[]::new);
        ArrayList<String> l = new ArrayList<String>();
        HashMap<Integer, Pattern> regexMap = new HashMap<Integer, Pattern>();
        for (int i = 0; i < segments.length; ++i) {
            Matcher m;
            String segment = segments[i];
            if (PathPattern.isParam(segment) && (m = FIND_REGEX.matcher(segment)).find()) {
                String extractedStr = m.group(0);
                String r = extractedStr.substring(1, extractedStr.length() - 1);
                Pattern p = Pattern.compile(r);
                regexMap.put(i, p);
                String paramName = segment.substring(0, segment.indexOf(extractedStr));
                l.add(paramName);
                continue;
            }
            l.add(segment);
        }
        return new Tuple2<List<String>, Map<Integer, Pattern>>(l, regexMap);
    }

    private static int[] paramsIndexes(List<String> patternSegments) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i2 = 0; i2 < patternSegments.size(); ++i2) {
            if (!PathPattern.isParam(patternSegments.get(i2))) continue;
            l.add(i2);
        }
        return l.stream().mapToInt(i -> i).toArray();
    }

    public boolean match(Path path) {
        int i;
        if (path.isEmpty() && (this.patternSegments.size() == 0 || PathPattern.isWildcard(this.patternSegments.get(0)))) {
            return true;
        }
        if (!path.isEmpty() && this.patternSegments.size() == 0) {
            return false;
        }
        for (i = 0; i < path.size() && i < this.patternSegments.size(); ++i) {
            if (path.get(i).equals(this.patternSegments.get(i)) || PathPattern.isWildcard(this.patternSegments.get(i)) || PathPattern.isParam(this.patternSegments.get(i)) && (this.regexes.get(i) == null || this.regexes.get(i).matcher(path.get(i)).find())) continue;
            return false;
        }
        return path.size() == this.patternSegments.size() || path.size() > this.patternSegments.size() && PathPattern.isWildcard(this.patternSegments.get(i - 1));
    }

    private static boolean isParam(String str) {
        return str.startsWith(":");
    }

    private static boolean isWildcard(String str) {
        return str.equals("*");
    }
}

