/*
 * Decompiled with CFR 0.152.
 */
package rsp.routing;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import rsp.routing.PathPattern;
import rsp.server.Path;

public final class PathMatchFunction<S>
implements Function<Path, CompletableFuture<S>> {
    private final PathPattern pathPattern;
    private final BiFunction<String, String, CompletableFuture<S>> matchFun;

    public PathMatchFunction(PathPattern pathPattern, BiFunction<String, String, CompletableFuture<S>> matchFun) {
        this.pathPattern = pathPattern;
        this.matchFun = matchFun;
    }

    @Override
    public CompletableFuture<S> apply(Path path) {
        return this.callMatchFun(path);
    }

    private CompletableFuture<S> callMatchFun(Path path) {
        int[] pathParameterIndexes = this.pathPattern.paramsIndexes;
        if (pathParameterIndexes.length == 0) {
            return this.matchFun.apply("", "");
        }
        if (pathParameterIndexes.length == 1) {
            assert (pathParameterIndexes[0] < path.size());
            return this.matchFun.apply(path.get(pathParameterIndexes[0]), "");
        }
        assert (pathParameterIndexes[0] < pathParameterIndexes[1]);
        assert (pathParameterIndexes[1] < path.size());
        return this.matchFun.apply(path.get(pathParameterIndexes[0]), path.get(pathParameterIndexes[1]));
    }
}

