/*
 * Decompiled with CFR 0.152.
 */
package rsp.routing;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import rsp.routing.PathPattern;
import rsp.server.HttpRequest;
import rsp.util.TriFunction;

public final class HttpRequestMatchFunction<S>
implements Function<HttpRequest, CompletableFuture<S>> {
    private final PathPattern pathPattern;
    private final TriFunction<HttpRequest, String, String, CompletableFuture<S>> matchFun;

    public HttpRequestMatchFunction(PathPattern pathPattern, TriFunction<HttpRequest, String, String, CompletableFuture<S>> matchFun) {
        this.pathPattern = pathPattern;
        this.matchFun = matchFun;
    }

    @Override
    public CompletableFuture<S> apply(HttpRequest httpRequest) {
        return this.callMatchFun(httpRequest);
    }

    private CompletableFuture<S> callMatchFun(HttpRequest request) {
        int[] pathParameterIndexes = this.pathPattern.paramsIndexes;
        if (pathParameterIndexes.length == 0) {
            return this.matchFun.apply(request, "", "");
        }
        if (pathParameterIndexes.length == 1) {
            assert (pathParameterIndexes[0] < request.path.size());
            return this.matchFun.apply(request, request.path.get(pathParameterIndexes[0]), "");
        }
        assert (pathParameterIndexes[0] < pathParameterIndexes[1]);
        assert (pathParameterIndexes[1] < request.path.size());
        return this.matchFun.apply(request, request.path.get(pathParameterIndexes[0]), request.path.get(pathParameterIndexes[1]));
    }
}

