/*
 * Decompiled with CFR 0.152.
 */
package rsp.page;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import rsp.dom.Event;
import rsp.dom.VirtualDomPath;
import rsp.dom.XmlNs;
import rsp.page.EventContext;
import rsp.page.PageRenderContext;
import rsp.ref.Ref;

public final class UpgradingPageRenderContext
implements PageRenderContext {
    private final PageRenderContext context;
    private final String pageInfo;
    private boolean headWasOpened = false;

    private UpgradingPageRenderContext(PageRenderContext context, String pageInfo) {
        this.context = context;
        this.pageInfo = pageInfo;
    }

    public static UpgradingPageRenderContext create(PageRenderContext context, String sessionId, String path, String connectionLostWidgetHtml, int heartBeatInterval) {
        String cfg = "window['kfg']={sid:'" + sessionId + "',r:'" + path + "',clw:'" + connectionLostWidgetHtml + "',heartbeatInterval:" + heartBeatInterval + "}";
        return new UpgradingPageRenderContext(context, cfg);
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.context.setStatusCode(statusCode);
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.context.setHeaders(headers);
    }

    @Override
    public void setDocType(String docType) {
        this.context.setDocType(docType);
    }

    @Override
    public void openNode(XmlNs xmlNs, String name) {
        if (!this.headWasOpened && xmlNs.equals(XmlNs.html) && name.equals("body")) {
            this.context.openNode(XmlNs.html, "head");
            this.upgradeHeadTag();
            this.context.closeNode("head", false);
        } else if (xmlNs.equals(XmlNs.html) && name.equals("head")) {
            this.headWasOpened = true;
        }
        this.context.openNode(xmlNs, name);
    }

    @Override
    public void closeNode(String name, boolean upgrade) {
        if (this.headWasOpened && upgrade && name.equals("head")) {
            this.upgradeHeadTag();
        }
        this.context.closeNode(name, upgrade);
    }

    private void upgradeHeadTag() {
        this.context.openNode(XmlNs.html, "script");
        this.context.addTextNode(this.pageInfo);
        this.context.closeNode("script", false);
        this.context.openNode(XmlNs.html, "script");
        this.context.setAttr(XmlNs.html, "src", "/static/rsp-client.min.js", false);
        this.context.setAttr(XmlNs.html, "defer", "defer", true);
        this.context.closeNode("script", true);
    }

    @Override
    public void setAttr(XmlNs xmlNs, String name, String value, boolean isProperty) {
        this.context.setAttr(xmlNs, name, value, isProperty);
    }

    @Override
    public void setStyle(String name, String value) {
        this.context.setStyle(name, value);
    }

    @Override
    public void addTextNode(String text) {
        this.context.addTextNode(text);
    }

    @Override
    public void addEvent(Optional<VirtualDomPath> elementPath, String eventName, Consumer<EventContext> eventHandler, boolean preventDefault, Event.Modifier modifier) {
        this.context.addEvent(elementPath, eventName, eventHandler, preventDefault, modifier);
    }

    @Override
    public void addRef(Ref ref) {
        this.context.addRef(ref);
    }

    public String toString() {
        return this.context.toString();
    }
}

