/*
 * Decompiled with CFR 0.152.
 */
package rsp.page;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import rsp.dom.DefaultDomChangesPerformer;
import rsp.dom.VirtualDomPath;
import rsp.dom.XmlNs;
import rsp.server.OutMessages;
import rsp.util.json.JsonDataType;

public final class PropertiesHandle {
    private final VirtualDomPath path;
    private final Supplier<Integer> descriptorSupplier;
    private final Map<Integer, CompletableFuture<JsonDataType>> registeredEventHandlers;
    private final OutMessages out;

    public PropertiesHandle(VirtualDomPath path, Supplier<Integer> descriptorSupplier, Map<Integer, CompletableFuture<JsonDataType>> registeredEventHandlers, OutMessages out) {
        this.path = Objects.requireNonNull(path);
        this.descriptorSupplier = Objects.requireNonNull(descriptorSupplier);
        this.registeredEventHandlers = Objects.requireNonNull(registeredEventHandlers);
        this.out = Objects.requireNonNull(out);
    }

    public CompletableFuture<JsonDataType> get(String propertyName) {
        Integer newDescriptor = this.descriptorSupplier.get();
        CompletableFuture<JsonDataType> valueFuture = new CompletableFuture<JsonDataType>();
        this.registeredEventHandlers.put(newDescriptor, valueFuture);
        this.out.extractProperty(newDescriptor, this.path, propertyName);
        return valueFuture;
    }

    public CompletionStage<String> getString(String propertyName) {
        return this.get(propertyName).thenApply(v -> v.toString());
    }

    public CompletableFuture<Void> set(String propertyName, String value) {
        this.out.modifyDom(List.of(new DefaultDomChangesPerformer.SetAttr(this.path, XmlNs.html, propertyName, value, true)));
        return new CompletableFuture<Void>();
    }
}

