/*
 * Decompiled with CFR 0.152.
 */
package rsp.page;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import rsp.Component;
import rsp.dom.DomTreePageRenderContext;
import rsp.dom.Tag;
import rsp.page.PageRenderContext;
import rsp.page.QualifiedSessionId;
import rsp.routing.Route;
import rsp.server.HttpRequest;
import rsp.server.HttpResponse;
import rsp.server.Path;
import rsp.state.ReadOnly;
import rsp.util.RandomString;
import rsp.util.data.Tuple2;

public final class PageRendering<S> {
    public static final int KEY_LENGTH = 64;
    public static final String DEVICE_ID_COOKIE_NAME = "deviceId";
    private final RandomString randomStringGenerator = new RandomString(64);
    private final Component<S> documentDefinition;
    private final Route<HttpRequest, S> routing;
    private final Map<QualifiedSessionId, RenderedPage<S>> renderedPages;
    private final BiFunction<String, PageRenderContext, PageRenderContext> enrich;

    public PageRendering(Route<HttpRequest, S> routing, Map<QualifiedSessionId, RenderedPage<S>> pagesStorage, Component<S> documentDefinition, BiFunction<String, PageRenderContext, PageRenderContext> enrich) {
        this.routing = routing;
        this.renderedPages = pagesStorage;
        this.documentDefinition = documentDefinition;
        this.enrich = enrich;
    }

    public CompletableFuture<HttpResponse> httpResponse(HttpRequest request) {
        if (request.path.endsWith("favicon.ico")) {
            return CompletableFuture.completedFuture(new HttpResponse(404, Collections.emptyList(), "No favicon.ico"));
        }
        if (request.path.startsWith("static")) {
            return this.staticFileResponse(request.path);
        }
        return this.rspResponse(request);
    }

    private CompletableFuture<HttpResponse> staticFileResponse(Path path) {
        return path.last().flatMap(fileName -> {
            URL fileUrl = this.getClass().getResource("/" + fileName);
            if (fileUrl != null) {
                try {
                    return Optional.of(CompletableFuture.completedFuture(new HttpResponse(200, Collections.emptyList(), fileUrl.openStream())));
                }
                catch (IOException e) {
                    return Optional.of(CompletableFuture.completedFuture(new HttpResponse(500, Collections.emptyList(), "Exception on loading a static resource: " + path + " " + e.getMessage())));
                }
            }
            return Optional.empty();
        }).orElse(CompletableFuture.completedFuture(new HttpResponse(404, Collections.emptyList(), "Resource not found: " + path)));
    }

    private CompletableFuture<HttpResponse> rspResponse(HttpRequest request) {
        try {
            String deviceId = request.cookie(DEVICE_ID_COOKIE_NAME).orElse(this.randomStringGenerator.newString());
            String sessionId = this.randomStringGenerator.newString();
            QualifiedSessionId pageId = new QualifiedSessionId(deviceId, sessionId);
            this.renderedPages.get(pageId);
            Optional route = (Optional)this.routing.apply(request);
            return route.isPresent() ? ((CompletableFuture)route.get()).thenApply(initialState -> {
                DomTreePageRenderContext domTreeContext = new DomTreePageRenderContext();
                this.documentDefinition.render(new ReadOnly<Object>(initialState)).accept(this.enrich.apply(sessionId, domTreeContext));
                this.renderedPages.put(pageId, new RenderedPage<Object>(request, initialState, domTreeContext.root()));
                return new HttpResponse(domTreeContext.statusCode(), this.headers(domTreeContext.headers(), deviceId), domTreeContext.toString());
            }) : this.defaultPage404();
        }
        catch (Throwable ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    private CompletableFuture<HttpResponse> defaultPage404() {
        return CompletableFuture.completedFuture(new HttpResponse(404, List.of(), "Not found"));
    }

    private List<Tuple2<String, String>> headers(Map<String, String> headers, String deviceId) {
        ArrayList<Tuple2<String, String>> resultHeaders = new ArrayList<Tuple2<String, String>>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            resultHeaders.add(new Tuple2<String, String>(entry.getKey(), entry.getValue()));
        }
        resultHeaders.add(new Tuple2<String, String>("content-type", "text/html; charset=utf-8"));
        resultHeaders.add(new Tuple2<String, String>("cache-control", "no-store, no-cache, must-revalidate"));
        resultHeaders.add(new Tuple2<String, String>("Set-Cookie", String.format("%s=%s; Path=%s; Max-Age=%d; SameSite=Lax", DEVICE_ID_COOKIE_NAME, deviceId, "/", 315360000)));
        return resultHeaders;
    }

    public static class RenderedPage<S> {
        public final HttpRequest request;
        public final S state;
        public final Tag domRoot;

        public RenderedPage(HttpRequest request, S initialState, Tag domRoot) {
            this.request = request;
            this.state = initialState;
            this.domRoot = domRoot;
        }
    }
}

