/*
 * Decompiled with CFR 0.152.
 */
package rsp.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import rsp.Component;
import rsp.dom.DefaultDomChangesPerformer;
import rsp.dom.Diff;
import rsp.dom.DomTreePageRenderContext;
import rsp.dom.Event;
import rsp.page.LivePagePropertiesSnapshot;
import rsp.page.PageRenderContext;
import rsp.page.QualifiedSessionId;
import rsp.page.StateToRouteDispatch;
import rsp.server.OutMessages;
import rsp.server.Path;
import rsp.state.UseState;

public class LivePageState<S>
implements UseState<S> {
    private final QualifiedSessionId qsid;
    private final StateToRouteDispatch<S> state2route;
    private final Component<S> rootComponent;
    private final BiFunction<String, PageRenderContext, PageRenderContext> enrich;
    private final OutMessages out;
    private S state;
    private LivePagePropertiesSnapshot snapshot;

    public LivePageState(LivePagePropertiesSnapshot snapshot, QualifiedSessionId qsid, StateToRouteDispatch<S> state2route, Component<S> rootComponent, BiFunction<String, PageRenderContext, PageRenderContext> enrich, OutMessages out) {
        this.snapshot = snapshot;
        this.qsid = qsid;
        this.state2route = state2route;
        this.rootComponent = rootComponent;
        this.enrich = enrich;
        this.out = out;
    }

    @Override
    public synchronized void accept(S newState) {
        this.state = newState;
        DomTreePageRenderContext newContext = new DomTreePageRenderContext();
        this.rootComponent.render(this).accept(this.enrich.apply(this.qsid.sessionId, newContext));
        DefaultDomChangesPerformer domChangePerformer = new DefaultDomChangesPerformer();
        new Diff(Optional.of(this.snapshot.domRoot), newContext.root(), domChangePerformer).run();
        if (domChangePerformer.commands.size() > 0) {
            this.out.modifyDom(domChangePerformer.commands);
        }
        HashSet<Event> oldEvents = new HashSet<Event>(this.snapshot.events.values());
        HashSet<Event> newEvents = new HashSet<Event>(newContext.events.values());
        HashSet<Event> eventsToRemove = new HashSet<Event>();
        for (Event event2 : oldEvents) {
            if (newEvents.contains(event2) || domChangePerformer.elementsToRemove.contains(event2.eventTarget.elementPath)) continue;
            eventsToRemove.add(event2);
        }
        eventsToRemove.forEach(event -> {
            Event.Target eventTarget = event.eventTarget;
            this.out.forgetEvent(eventTarget.eventType, eventTarget.elementPath);
        });
        HashSet<Event> eventsToAdd = new HashSet<Event>();
        for (Event event3 : newEvents) {
            if (oldEvents.contains(event3)) continue;
            eventsToAdd.add(event3);
        }
        this.out.listenEvents(new ArrayList<Event>(eventsToAdd));
        Path path = this.snapshot.path;
        Path newPath = this.state2route.stateToPath.apply(newState, path);
        if (!newPath.equals(path)) {
            this.out.pushHistory(this.state2route.basePath.resolve(newPath).toString());
        }
        this.snapshot = new LivePagePropertiesSnapshot(newPath, newContext.root(), Collections.unmodifiableMap(newContext.events), Collections.unmodifiableMap(newContext.refs));
    }

    @Override
    public synchronized S get() {
        return this.state;
    }

    @Override
    public synchronized void accept(CompletableFuture<S> completableFuture) {
        completableFuture.thenAccept(s -> this.accept((S)s));
    }

    @Override
    public synchronized void accept(Function<S, S> function) {
        this.accept(function.apply(this.get()));
    }

    @Override
    public synchronized void acceptOptional(Function<S, Optional<S>> function) {
        function.apply(this.state).ifPresent(s -> this.accept((S)s));
    }

    public synchronized LivePagePropertiesSnapshot snapshot() {
        return this.snapshot;
    }
}

