/*
 * Decompiled with CFR 0.152.
 */
package rsp.page;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import rsp.dom.Event;
import rsp.dom.VirtualDomPath;
import rsp.html.WindowRef;
import rsp.page.EventContext;
import rsp.page.LivePageState;
import rsp.page.PropertiesHandle;
import rsp.page.QualifiedSessionId;
import rsp.page.Schedule;
import rsp.page.Timer;
import rsp.ref.Ref;
import rsp.server.InMessages;
import rsp.server.OutMessages;
import rsp.util.data.Either;
import rsp.util.json.JsonDataType;
import rsp.util.logging.Log;

public final class LivePage<S>
implements InMessages,
Schedule {
    public final QualifiedSessionId qsid;
    private final LivePageState<S> pageState;
    private final ScheduledExecutorService scheduledExecutorService;
    private final OutMessages out;
    private final Log.Reporting log;
    private int descriptorsCounter;
    private final Map<Integer, CompletableFuture<JsonDataType>> registeredEventHandlers = new HashMap<Integer, CompletableFuture<JsonDataType>>();
    private final Map<Object, ScheduledFuture<?>> schedules = new HashMap();

    public LivePage(QualifiedSessionId qsid, LivePageState<S> pageState, ScheduledExecutorService scheduledExecutorService, OutMessages out, Log.Reporting log) {
        this.qsid = qsid;
        this.pageState = pageState;
        this.scheduledExecutorService = scheduledExecutorService;
        this.out = out;
        this.log = log;
    }

    public S getPageState() {
        return this.pageState.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.log.debug(l -> l.log("Live Page shutdown: " + this));
        LivePageState<S> livePageState = this.pageState;
        synchronized (livePageState) {
            for (Map.Entry<Object, ScheduledFuture<?>> timer : this.schedules.entrySet()) {
                timer.getValue().cancel(true);
            }
        }
    }

    @Override
    public void handleExtractPropertyResponse(int descriptorId, Either<Throwable, JsonDataType> result) {
        result.on(ex -> {
            this.log.debug(l -> l.log("extractProperty: " + descriptorId + " exception: " + ex.getMessage()));
            LivePageState<S> livePageState = this.pageState;
            synchronized (livePageState) {
                CompletableFuture<JsonDataType> cf = this.registeredEventHandlers.get(descriptorId);
                if (cf != null) {
                    cf.completeExceptionally((Throwable)ex);
                    this.registeredEventHandlers.remove(descriptorId);
                }
            }
        }, v -> {
            this.log.debug(l -> l.log("extractProperty: " + descriptorId + " value: " + v.toStringValue()));
            LivePageState<S> livePageState = this.pageState;
            synchronized (livePageState) {
                CompletableFuture<JsonDataType> cf = this.registeredEventHandlers.get(descriptorId);
                if (cf != null) {
                    cf.complete((JsonDataType)v);
                    this.registeredEventHandlers.remove(descriptorId);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvalJsResponse(int descriptorId, JsonDataType value) {
        this.log.debug(l -> l.log("evalJsResponse: " + descriptorId + " value: " + value.toStringValue()));
        LivePageState<S> livePageState = this.pageState;
        synchronized (livePageState) {
            CompletableFuture<JsonDataType> cf = this.registeredEventHandlers.get(descriptorId);
            if (cf != null) {
                cf.complete(value);
                this.registeredEventHandlers.remove(descriptorId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDomEvent(int renderNumber, VirtualDomPath path, String eventType, JsonDataType.Object eventObject) {
        LivePageState<S> livePageState = this.pageState;
        synchronized (livePageState) {
            VirtualDomPath eventElementPath = path;
            while (eventElementPath.level() > 0) {
                Event event = this.pageState.snapshot().events.get(new Event.Target(eventType, eventElementPath));
                if (event != null && event.eventTarget.eventType.equals(eventType)) {
                    EventContext eventContext = this.createEventContext(eventObject);
                    event.eventHandler.accept(eventContext);
                    break;
                }
                Optional<VirtualDomPath> parentPath = eventElementPath.parent();
                if (!parentPath.isPresent()) break;
                eventElementPath = parentPath.get();
            }
        }
    }

    @Override
    public synchronized Timer scheduleAtFixedRate(Runnable command, Object key, long initialDelay, long period, TimeUnit unit) {
        ScheduledFuture<?> timer = this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            LivePageState<S> livePageState = this.pageState;
            synchronized (livePageState) {
                command.run();
            }
        }, initialDelay, period, unit);
        this.schedules.put(key, timer);
        return new Timer(key, () -> this.cancel(key));
    }

    @Override
    public synchronized Timer schedule(Runnable command, Object key, long delay, TimeUnit unit) {
        ScheduledFuture<?> timer = this.scheduledExecutorService.schedule(() -> {
            LivePageState<S> livePageState = this.pageState;
            synchronized (livePageState) {
                command.run();
            }
        }, delay, unit);
        this.schedules.put(key, timer);
        return new Timer(key, () -> this.cancel(key));
    }

    @Override
    public synchronized void cancel(Object key) {
        ScheduledFuture<?> schedule = this.schedules.get(key);
        if (schedule != null) {
            schedule.cancel(true);
            this.schedules.remove(key);
        }
    }

    private EventContext createEventContext(JsonDataType.Object eventObject) {
        return new EventContext(this.qsid, js -> this.evalJs((String)js), ref -> this.createPropertiesHandle((Ref)ref), eventObject, this, href -> this.setHref((String)href));
    }

    private PropertiesHandle createPropertiesHandle(Ref ref) {
        VirtualDomPath path = this.resolveRef(ref);
        if (path == null) {
            throw new IllegalStateException("Ref not found: " + ref);
        }
        return new PropertiesHandle(path, () -> ++this.descriptorsCounter, this.registeredEventHandlers, this.out);
    }

    private VirtualDomPath resolveRef(Ref ref) {
        return ref instanceof WindowRef ? VirtualDomPath.DOCUMENT : this.pageState.snapshot().refs.get(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<JsonDataType> evalJs(String js) {
        LivePageState<S> livePageState = this.pageState;
        synchronized (livePageState) {
            int newDescriptor = ++this.descriptorsCounter;
            CompletableFuture<JsonDataType> resultHandler = new CompletableFuture<JsonDataType>();
            this.registeredEventHandlers.put(newDescriptor, resultHandler);
            this.out.evalJs(newDescriptor, js);
            return resultHandler;
        }
    }

    private void setHref(String path) {
        this.out.setHref(path);
    }

    private void pushHistory(String path) {
        this.out.pushHistory(path);
    }
}

