/*
 * Decompiled with CFR 0.152.
 */
package rsp.page;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import rsp.page.PropertiesHandle;
import rsp.page.QualifiedSessionId;
import rsp.page.Schedule;
import rsp.page.Timer;
import rsp.ref.ElementRef;
import rsp.ref.Ref;
import rsp.ref.TimerRef;
import rsp.util.json.JsonDataType;

public final class EventContext {
    private final QualifiedSessionId sessionId;
    private final Function<Ref, PropertiesHandle> propertiesHandleLookup;
    private final Function<String, CompletableFuture<JsonDataType>> jsEvaluation;
    private final JsonDataType.Object eventObject;
    private final Schedule executorService;
    private final Consumer<String> setHref;

    public EventContext(QualifiedSessionId sessionId, Function<String, CompletableFuture<JsonDataType>> jsEvaluation, Function<Ref, PropertiesHandle> propertiesHandleLookup, JsonDataType.Object eventObject, Schedule executorService, Consumer<String> setHref) {
        this.sessionId = sessionId;
        this.propertiesHandleLookup = propertiesHandleLookup;
        this.jsEvaluation = jsEvaluation;
        this.eventObject = eventObject;
        this.executorService = executorService;
        this.setHref = setHref;
    }

    public PropertiesHandle props(ElementRef ref) {
        return this.propertiesHandleLookup.apply(ref);
    }

    public CompletableFuture<JsonDataType> evalJs(String js) {
        return this.jsEvaluation.apply(js);
    }

    public void setHref(String href) {
        this.setHref.accept(href);
    }

    public QualifiedSessionId sessionId() {
        return this.sessionId;
    }

    public JsonDataType.Object eventObject() {
        return this.eventObject;
    }

    public Timer schedule(Runnable command, int delay, TimeUnit timeUnit) {
        return this.executorService.schedule(command, new Object(), delay, timeUnit);
    }

    public Timer schedule(Runnable command, TimerRef ref, int delay, TimeUnit timeUnit) {
        return this.executorService.schedule(command, ref, delay, timeUnit);
    }

    public Timer scheduleAtFixedRate(Runnable command, int delay, int period, TimeUnit timeUnit) {
        return this.executorService.scheduleAtFixedRate(command, new Object(), delay, period, timeUnit);
    }

    public Timer scheduleAtFixedRate(Runnable command, TimerRef ref, int delay, int period, TimeUnit timeUnit) {
        return this.executorService.scheduleAtFixedRate(command, ref, delay, period, timeUnit);
    }

    public void cancelSchedule(TimerRef ref) {
        this.executorService.cancel(ref);
    }
}

