/*
 * Decompiled with CFR 0.152.
 */
package rsp.jetty;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import rsp.App;
import rsp.javax.web.HttpRequestUtils;
import rsp.javax.web.MainHttpServlet;
import rsp.javax.web.MainWebSocketEndpoint;
import rsp.page.DefaultConnectionLostWidget;
import rsp.page.PageRenderContext;
import rsp.page.PageRendering;
import rsp.page.StateToRouteDispatch;
import rsp.page.UpgradingPageRenderContext;
import rsp.server.Path;
import rsp.server.SslConfiguration;
import rsp.server.StaticResources;

public final class JettyServer<S> {
    public static final int DEFAULT_WEB_SERVER_MAX_THREADS = 50;
    private final int port;
    private final Path basePath;
    private final App<S> app;
    private final Server server;

    public JettyServer(int port, String basePath, App<S> app, Optional<StaticResources> staticResources, Optional<SslConfiguration> sslConfiguration, int maxThreads) {
        this.port = port;
        this.basePath = Objects.requireNonNull(Path.of(basePath));
        this.app = Objects.requireNonNull(app);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(maxThreads);
        this.server = new Server((ThreadPool)threadPool);
        sslConfiguration.ifPresentOrElse(ssl -> {
            HttpConfiguration https = new HttpConfiguration();
            https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(ssl.keyStorePath);
            sslContextFactory.setKeyStorePassword(ssl.keyStorePassword);
            sslContextFactory.setKeyManagerPassword(ssl.keyStorePassword);
            ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
            sslConnector.setPort(port);
            this.server.setConnectors(new Connector[]{sslConnector});
        }, () -> {
            ServerConnector connector = new ServerConnector(this.server);
            connector.setPort(port);
            this.server.setConnectors(new Connector[]{connector});
        });
        HandlerList handlers = new HandlerList();
        staticResources.ifPresent(sr -> {
            ResourceHandler resourcesHandler = new ResourceHandler();
            resourcesHandler.setDirectoriesListed(true);
            resourcesHandler.setResourceBase(sr.resourcesBaseDir.getAbsolutePath());
            ContextHandler resourceContextHandler = new ContextHandler();
            resourceContextHandler.setHandler((Handler)resourcesHandler);
            resourceContextHandler.setContextPath(sr.contextPath);
            handlers.addHandler((Handler)resourceContextHandler);
        });
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/" + basePath);
        BiFunction<String, PageRenderContext, PageRenderContext> enrichContextFun = (sessionId, ctx) -> UpgradingPageRenderContext.create(ctx, sessionId, "/", DefaultConnectionLostWidget.HTML, app.config.heartbeatIntervalMs);
        context.addServlet(new ServletHolder(new MainHttpServlet(new PageRendering(app.routes, app.pagesStorage, app.rootComponent, enrichContextFun), app.config.log)), "/*");
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(app.config.schedulerThreadPoolSize);
        final MainWebSocketEndpoint webSocketEndpoint = new MainWebSocketEndpoint(new StateToRouteDispatch(this.basePath, app.state2path), app.pagesStorage, app.rootComponent, enrichContextFun, () -> scheduler, app.lifeCycleEventsListener, app.config.log);
        WebSocketServerContainerInitializer.configure((ServletContextHandler)context, (servletContext, serverContainer) -> {
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create(((Object)((Object)webSocketEndpoint)).getClass(), (String)"/bridge/web-socket/{pid}/{sid}").configurator(new ServerEndpointConfig.Configurator(){

                public <T> T getEndpointInstance(Class<T> clazz) throws InstantiationException {
                    if (clazz.equals(MainWebSocketEndpoint.class)) {
                        MainWebSocketEndpoint endpoint = webSocketEndpoint;
                        return (T)((Object)endpoint);
                    }
                    throw new InstantiationException("Expected class " + MainWebSocketEndpoint.class + " got " + clazz);
                }

                public void modifyHandshake(ServerEndpointConfig conf, HandshakeRequest req, HandshakeResponse resp) {
                    conf.getUserProperties().put("handshakereq", HttpRequestUtils.httpRequest(req));
                }
            }).build();
            serverContainer.addEndpoint(config);
        });
        handlers.addHandler((Handler)context);
        this.server.setHandler((Handler)handlers);
    }

    public JettyServer(int port, String basePath, App<S> app, StaticResources staticResources) {
        this(port, basePath, app, Optional.of(staticResources), Optional.empty(), 50);
    }

    public JettyServer(int port, String basePath, App<S> app, StaticResources staticResources, SslConfiguration sslConfiguration) {
        this(port, basePath, app, Optional.of(staticResources), Optional.of(sslConfiguration), 50);
    }

    public JettyServer(int port, String basePath, App<S> app) {
        this(port, basePath, app, Optional.empty(), Optional.empty(), 50);
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.app.config.log.info(l -> l.log("Server started, listening on port: " + this.port));
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

