/*
 * Decompiled with CFR 0.152.
 */
package rsp.javax.web;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import rsp.Component;
import rsp.javax.web.HttpRequestUtils;
import rsp.page.LivePage;
import rsp.page.LivePagePropertiesSnapshot;
import rsp.page.LivePageState;
import rsp.page.PageLifeCycle;
import rsp.page.PageRenderContext;
import rsp.page.PageRendering;
import rsp.page.QualifiedSessionId;
import rsp.page.StateToRouteDispatch;
import rsp.server.DeserializeInMessage;
import rsp.server.HttpRequest;
import rsp.server.SerializeOutMessages;
import rsp.util.logging.Log;

public final class MainWebSocketEndpoint<S>
extends Endpoint {
    public static final String WS_ENDPOINT_PATH = "/bridge/web-socket/{pid}/{sid}";
    public static final String HANDSHAKE_REQUEST_PROPERTY_NAME = "handshakereq";
    private static final String LIVE_PAGE_SESSION_USER_PROPERTY_NAME = "livePage";
    private final Component<S> documentDefinition;
    private final StateToRouteDispatch<S> state2route;
    private final Map<QualifiedSessionId, PageRendering.RenderedPage<S>> renderedPages;
    private final BiFunction<String, PageRenderContext, PageRenderContext> enrich;
    private final Supplier<ScheduledExecutorService> schedulerSupplier;
    private final PageLifeCycle<S> lifeCycleEventsListener;
    private final Log.Reporting log;
    private static final Set<QualifiedSessionId> lostSessionsIds = Collections.newSetFromMap(new WeakHashMap());

    public MainWebSocketEndpoint(StateToRouteDispatch<S> state2route, Map<QualifiedSessionId, PageRendering.RenderedPage<S>> renderedPages, Component<S> documentDefinition, BiFunction<String, PageRenderContext, PageRenderContext> enrich, Supplier<ScheduledExecutorService> schedulerSupplier, PageLifeCycle<S> lifeCycleEventsListener, Log.Reporting log) {
        this.state2route = state2route;
        this.renderedPages = renderedPages;
        this.documentDefinition = documentDefinition;
        this.enrich = enrich;
        this.schedulerSupplier = schedulerSupplier;
        this.lifeCycleEventsListener = lifeCycleEventsListener;
        this.log = log;
    }

    public void onOpen(final Session session, EndpointConfig endpointConfig) {
        this.log.debug(l -> l.log("Websocket endpoint opened, session: " + session.getId()));
        SerializeOutMessages out = new SerializeOutMessages(msg -> this.sendText(session, (String)msg));
        HttpRequest handshakeRequest = (HttpRequest)endpointConfig.getUserProperties().get(HANDSHAKE_REQUEST_PROPERTY_NAME);
        QualifiedSessionId qsid = new QualifiedSessionId((String)session.getPathParameters().get("pid"), (String)session.getPathParameters().get("sid"));
        PageRendering.RenderedPage<S> page = this.renderedPages.get(qsid);
        if (page == null) {
            this.log.trace(l -> l.log("Pre-rendered page not found for SID: " + qsid));
            if (!MainWebSocketEndpoint.isKnownLostSession(qsid)) {
                this.log.warn(l -> l.log("Reload a remote on: " + handshakeRequest.uri.getHost() + ":" + handshakeRequest.uri.getPort()));
                out.evalJs(-1, "RSP.reload()");
            }
        } else {
            this.renderedPages.remove(qsid);
            LivePagePropertiesSnapshot currentPageSnapshot = new LivePagePropertiesSnapshot(page.request.path, page.domRoot, Map.of(), Map.of());
            LivePageState livePageState = new LivePageState(currentPageSnapshot, qsid, this.state2route, this.documentDefinition, this.enrich, out);
            this.lifeCycleEventsListener.beforeLivePageCreated(qsid, livePageState);
            LivePage<S> livePage = new LivePage<S>(qsid, livePageState, this.schedulerSupplier.get(), out, this.log);
            session.getUserProperties().put(LIVE_PAGE_SESSION_USER_PROPERTY_NAME, livePage);
            final DeserializeInMessage in = new DeserializeInMessage(livePage, this.log);
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String s) {
                    MainWebSocketEndpoint.this.log.trace(l -> l.log(session.getId() + " -> " + s));
                    in.parse(s);
                }
            });
            livePageState.accept(page.state);
            out.setRenderNum(0);
            this.log.debug(l -> l.log("Live page started: " + this));
        }
    }

    private void sendText(Session session, String text) {
        try {
            this.log.trace(l -> l.log(session.getId() + " <- " + text));
            session.getBasicRemote().sendText(text);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.shutdown(session);
        this.log.debug(l -> l.log("WebSocket closed " + closeReason.getReasonPhrase()));
    }

    public void onError(Session session, Throwable thr) {
        this.shutdown(session);
        this.log.error(l -> l.log("WebSocket error: " + thr.getLocalizedMessage(), thr));
    }

    private void shutdown(Session session) {
        LivePage livePage = (LivePage)session.getUserProperties().get(LIVE_PAGE_SESSION_USER_PROPERTY_NAME);
        if (livePage != null) {
            livePage.shutdown();
            this.lifeCycleEventsListener.afterLivePageClosed(livePage.qsid, livePage.getPageState());
            this.log.debug(l -> l.log("Shutdown session: " + session.getId()));
        }
    }

    public static HttpRequest of(HandshakeRequest handshakeRequest) {
        return HttpRequestUtils.httpRequest(handshakeRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isKnownLostSession(QualifiedSessionId qsid) {
        Set<QualifiedSessionId> set = lostSessionsIds;
        synchronized (set) {
            if (lostSessionsIds.contains(qsid)) {
                return true;
            }
            lostSessionsIds.add(qsid);
            return false;
        }
    }
}

