/*
 * Decompiled with CFR 0.152.
 */
package rsp.javax.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import rsp.javax.web.HttpRequestUtils;
import rsp.page.PageRendering;
import rsp.server.HttpRequest;
import rsp.server.HttpResponse;
import rsp.util.ExceptionsUtils;
import rsp.util.logging.Log;

public final class MainHttpServlet<S>
extends HttpServlet {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final PageRendering<S> pageRendering;
    private final Log.Reporting log;

    public MainHttpServlet(PageRendering<S> pageRendering, Log.Reporting log) {
        this.pageRendering = pageRendering;
        this.log = log;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.handleRequestAsync(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.handleRequestAsync(request, response);
    }

    private void handleRequestAsync(HttpServletRequest request, HttpServletResponse response) {
        AsyncContext asyncContext = request.startAsync();
        asyncContext.start(() -> {
            HttpRequest req = HttpRequestUtils.httpRequest(request);
            this.log.trace(l -> l.log(request.getRemoteAddr() + " -> " + request.getMethod() + " " + request.getRequestURL()));
            ((CompletableFuture)this.pageRendering.httpResponse(req).handle((resp, ex) -> {
                if (ex != null) {
                    this.log.error(l -> l.log("Http rendering exception", (Throwable)ex));
                    return new HttpResponse(500, Collections.emptyList(), MainHttpServlet.exceptionDetails(ex));
                }
                return resp;
            })).thenAccept(resp -> {
                this.setServletResponse((HttpResponse)resp, response);
                this.log.trace(l -> l.log(request.getRemoteAddr() + " <- " + response.getStatus()));
                asyncContext.complete();
            });
        });
    }

    private static String exceptionDetails(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        sb.append("500 Internal server error\n");
        sb.append("Exception: " + ex.getMessage() + "\n");
        sb.append(ExceptionsUtils.stackTraceToString(ex));
        return sb.toString();
    }

    private void setServletResponse(HttpResponse resp, HttpServletResponse response) {
        response.setStatus(resp.status);
        resp.headers.stream().forEach(h -> response.addHeader((String)h._1, (String)h._2));
        try (InputStream inputStream = resp.bodyStream;
             ServletOutputStream outputStream = response.getOutputStream();){
            MainHttpServlet.copy(inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copy(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = source.read(buf)) > 0) {
            target.write(buf, 0, length);
        }
    }
}

