/*
 * Decompiled with CFR 0.152.
 */
package rsp.javax.web;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.server.HandshakeRequest;
import rsp.server.HttpRequest;
import rsp.server.Path;

public final class HttpRequestUtils {
    public static HttpRequest httpRequest(HttpServletRequest request) {
        return new HttpRequest(HttpRequestUtils.httpMethod(request.getMethod()), HttpRequestUtils.stringToURI(request.getRequestURI()), request.getRequestURL().toString(), Path.of(request.getPathInfo()), s -> Optional.ofNullable(request.getParameter(s)), h -> Optional.ofNullable(request.getHeader(h)));
    }

    public static HttpRequest httpRequest(HandshakeRequest handshakeRequest) {
        return new HttpRequest(HttpRequest.HttpMethod.GET, handshakeRequest.getRequestURI(), handshakeRequest.getRequestURI().toString(), Path.of(handshakeRequest.getRequestURI().getPath()), name -> Optional.ofNullable((List)handshakeRequest.getParameterMap().get(name)).map(val -> (String)val.get(0)), name -> Optional.ofNullable((List)handshakeRequest.getHeaders().get(name)).map(val -> (String)val.get(0)));
    }

    private static URI stringToURI(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static HttpRequest.HttpMethod httpMethod(String method) {
        try {
            return HttpRequest.HttpMethod.valueOf(method);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Unsupported HTTP method: " + method, ex);
        }
    }
}

