/*
 * Decompiled with CFR 0.152.
 */
package rsp.html;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import rsp.dom.Event;
import rsp.dom.XmlNs;
import rsp.html.AttributeDefinition;
import rsp.html.DocumentPartDefinition;
import rsp.html.ElementRefDefinition;
import rsp.html.EmptyDefinition;
import rsp.html.EventDefinition;
import rsp.html.HtmlDocumentDefinition;
import rsp.html.PlainTagDefinition;
import rsp.html.SequenceDefinition;
import rsp.html.StyleDefinition;
import rsp.html.TagDefinition;
import rsp.html.TextDefinition;
import rsp.html.WindowRef;
import rsp.page.EventContext;
import rsp.util.ArrayUtils;

public final class HtmlDsl {
    public static final String DEFAULT_PROPERTIES_NAMES = "autofocus, autoplay, async, checked, controls, defer, disabled, hidden, loop, multiple, open, readonly, required, scoped, selected, value";

    public static HtmlDocumentDefinition html(DocumentPartDefinition ... children) {
        return new HtmlDocumentDefinition(200, Map.of(), children);
    }

    public static TagDefinition xmlTag(XmlNs ns, String name, DocumentPartDefinition ... children) {
        return new TagDefinition(ns, name, children);
    }

    public static TagDefinition tag(String name, DocumentPartDefinition ... children) {
        return HtmlDsl.xmlTag(XmlNs.html, name, children);
    }

    public static AttributeDefinition attr(String name, String value, boolean isProperty) {
        return new AttributeDefinition(name, value, isProperty);
    }

    public static AttributeDefinition prop(String name, String value) {
        return HtmlDsl.attr(name, value, true);
    }

    public static AttributeDefinition attr(String name, String value) {
        return HtmlDsl.attr(name, value, HtmlDsl.isPropertyByDefault(name));
    }

    public static AttributeDefinition attr(String name) {
        return new AttributeDefinition(name, name, HtmlDsl.isPropertyByDefault(name));
    }

    public static EventDefinition on(String eventType, Consumer<EventContext> handler) {
        return new EventDefinition(eventType, handler, Event.NO_MODIFIER);
    }

    public static EventDefinition on(String eventType, boolean preventDefault, Consumer<EventContext> handler) {
        return new EventDefinition(eventType, handler, preventDefault, Event.NO_MODIFIER);
    }

    public static StyleDefinition style(String name, String value) {
        return new StyleDefinition(name, value);
    }

    public static TextDefinition text(String text) {
        return new TextDefinition(text);
    }

    public static TextDefinition text(Object obj) {
        return new TextDefinition(obj.toString());
    }

    public static TagDefinition body(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("body", children);
    }

    public static TagDefinition head(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("head", children);
    }

    public static TagDefinition headPlain(DocumentPartDefinition ... children) {
        return new PlainTagDefinition(XmlNs.html, "head", children);
    }

    public static TagDefinition title(String text) {
        return HtmlDsl.tag("title", HtmlDsl.text(text));
    }

    public static TagDefinition link(AttributeDefinition ... children) {
        return HtmlDsl.tag("link", children);
    }

    public static TagDefinition meta(AttributeDefinition ... children) {
        return HtmlDsl.tag("meta", children);
    }

    public static TagDefinition h1(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("h1", children);
    }

    public static TagDefinition h1(String text) {
        return HtmlDsl.h1(HtmlDsl.text(text));
    }

    public static TagDefinition h2(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("h2", children);
    }

    public static TagDefinition h2(String text) {
        return HtmlDsl.h2(HtmlDsl.text(text));
    }

    public static TagDefinition h3(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("h3", children);
    }

    public static TagDefinition h3(String text) {
        return HtmlDsl.h3(HtmlDsl.text(text));
    }

    public static TagDefinition h4(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("h4", children);
    }

    public static TagDefinition h4(String text) {
        return HtmlDsl.h4(HtmlDsl.text(text));
    }

    public static TagDefinition h5(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("h5", children);
    }

    public static TagDefinition h5(String text) {
        return HtmlDsl.h5(HtmlDsl.text(text));
    }

    public static TagDefinition h6(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("h6", children);
    }

    public static TagDefinition h6(String text) {
        return HtmlDsl.h6(HtmlDsl.text(text));
    }

    public static TagDefinition div(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("div", children);
    }

    public static TagDefinition div(String text) {
        return HtmlDsl.div(HtmlDsl.text(text));
    }

    public static TagDefinition a(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("a", children);
    }

    public static TagDefinition a(String href, String text, DocumentPartDefinition ... children) {
        return HtmlDsl.a(ArrayUtils.concat(new DocumentPartDefinition[]{HtmlDsl.attr("href", href), HtmlDsl.text(text)}, children));
    }

    public static TagDefinition p(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("p", children);
    }

    public static TagDefinition p(String text) {
        return HtmlDsl.p(HtmlDsl.text(text));
    }

    public static TagDefinition span(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("span", children);
    }

    public static TagDefinition span(String text) {
        return HtmlDsl.span(HtmlDsl.text(text));
    }

    public static TagDefinition form(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("form", children);
    }

    public static TagDefinition input(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("input", children);
    }

    public static TagDefinition button(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("button", children);
    }

    public static TagDefinition ul(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("ul", children);
    }

    public static TagDefinition ol(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("ol", children);
    }

    public static TagDefinition li(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("li", children);
    }

    public static TagDefinition li(String text) {
        return HtmlDsl.li(HtmlDsl.text(text));
    }

    public static TagDefinition table(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("table", children);
    }

    public static TagDefinition thead(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("thead", children);
    }

    public static TagDefinition tbody(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("tbody", children);
    }

    public static TagDefinition th(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("th", children);
    }

    public static TagDefinition th(String text) {
        return HtmlDsl.th(HtmlDsl.text(text));
    }

    public static TagDefinition tr(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("tr", children);
    }

    public static TagDefinition td(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("td", children);
    }

    public static TagDefinition td(String text) {
        return HtmlDsl.td(HtmlDsl.text(text));
    }

    public static TagDefinition label(DocumentPartDefinition ... children) {
        return HtmlDsl.tag("label", children);
    }

    public static TagDefinition br() {
        return HtmlDsl.tag("br", new DocumentPartDefinition[0]);
    }

    public static SequenceDefinition of(Stream<DocumentPartDefinition> items) {
        return new SequenceDefinition((DocumentPartDefinition[])items.toArray(DocumentPartDefinition[]::new));
    }

    public static SequenceDefinition of(Supplier<DocumentPartDefinition> itemSupplier) {
        return new SequenceDefinition(new DocumentPartDefinition[]{itemSupplier.get()});
    }

    public static DocumentPartDefinition of(CompletableFuture<? extends DocumentPartDefinition> completableFutureDefinition) {
        return completableFutureDefinition.join();
    }

    public static DocumentPartDefinition when(boolean condition, DocumentPartDefinition then) {
        return HtmlDsl.when(condition, () -> then);
    }

    public static DocumentPartDefinition when(boolean condition, Supplier<DocumentPartDefinition> then) {
        return condition ? then.get() : EmptyDefinition.INSTANCE;
    }

    public static WindowRef window() {
        return new WindowRef();
    }

    public static ElementRefDefinition createElementRef() {
        return new ElementRefDefinition();
    }

    private static boolean isPropertyByDefault(String name) {
        return DEFAULT_PROPERTIES_NAMES.contains(name);
    }
}

