/*
 * Decompiled with CFR 0.152.
 */
package rsp.html;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import rsp.dom.XmlNs;
import rsp.html.DocumentPartDefinition;
import rsp.html.TagDefinition;
import rsp.page.PageRenderContext;

public final class HtmlDocumentDefinition
extends TagDefinition {
    private final int statusCode;
    private final Map<String, String> headers;

    public HtmlDocumentDefinition(int statusCode, Map<String, String> headers, DocumentPartDefinition ... children) {
        super(XmlNs.html, "html", children);
        this.statusCode = statusCode;
        this.headers = Objects.requireNonNull(headers);
    }

    @Override
    public void accept(PageRenderContext renderContext) {
        renderContext.setStatusCode(this.statusCode);
        renderContext.setHeaders(this.headers);
        renderContext.setDocType("<!DOCTYPE html>");
        super.accept(renderContext);
    }

    public HtmlDocumentDefinition statusCode(int statusCode) {
        return new HtmlDocumentDefinition(statusCode, this.headers, this.children);
    }

    public HtmlDocumentDefinition addHeaders(Map<String, String> headers) {
        return new HtmlDocumentDefinition(this.statusCode, HtmlDocumentDefinition.mergeMaps(this.headers, headers), this.children);
    }

    public HtmlDocumentDefinition redirect(String location) {
        return new HtmlDocumentDefinition(302, HtmlDocumentDefinition.mergeMaps(this.headers, Map.of("Location", location)), this.children);
    }

    private static Map<String, String> mergeMaps(Map<String, String> m1, Map<String, String> m2) {
        HashMap<String, String> result = new HashMap<String, String>(m1);
        result.putAll(m2);
        return result;
    }
}

