/*
 * Decompiled with CFR 0.152.
 */
package rsp.html;

import java.util.Optional;
import java.util.function.Consumer;
import rsp.dom.Event;
import rsp.dom.VirtualDomPath;
import rsp.html.DocumentPartDefinition;
import rsp.page.EventContext;
import rsp.page.PageRenderContext;

public final class EventDefinition
implements DocumentPartDefinition {
    public static boolean PREVENT_DEFAULT_DEFAULT_VALUE = true;
    public final Optional<VirtualDomPath> elementPath;
    public final String eventType;
    public final Consumer<EventContext> handler;
    public final boolean preventDefault;
    public final Event.Modifier modifier;

    public EventDefinition(Optional<VirtualDomPath> elementPath, String eventType, Consumer<EventContext> handler, boolean preventDefault, Event.Modifier modifier) {
        this.elementPath = elementPath;
        this.eventType = eventType;
        this.handler = handler;
        this.preventDefault = preventDefault;
        this.modifier = modifier;
    }

    public EventDefinition(String eventType, Consumer<EventContext> handler, Event.Modifier modifier) {
        this.elementPath = Optional.empty();
        this.eventType = eventType;
        this.handler = handler;
        this.preventDefault = PREVENT_DEFAULT_DEFAULT_VALUE;
        this.modifier = modifier;
    }

    public EventDefinition(String eventType, Consumer<EventContext> handler, boolean preventDefault, Event.Modifier modifier) {
        this.elementPath = Optional.empty();
        this.eventType = eventType;
        this.handler = handler;
        this.preventDefault = preventDefault;
        this.modifier = modifier;
    }

    @Override
    public void accept(PageRenderContext renderContext) {
        renderContext.addEvent(this.elementPath, this.eventType, this.handler, this.preventDefault, this.modifier);
    }

    public EventDefinition throttle(int timeFrameMs) {
        return new EventDefinition(this.elementPath, this.eventType, this.handler, this.preventDefault, new Event.ThrottleModifier(timeFrameMs));
    }

    public EventDefinition debounce(int waitMs, boolean immediate) {
        return new EventDefinition(this.elementPath, this.eventType, this.handler, this.preventDefault, new Event.DebounceModifier(waitMs, immediate));
    }

    public EventDefinition debounce(int waitMs) {
        return new EventDefinition(this.elementPath, this.eventType, this.handler, this.preventDefault, new Event.DebounceModifier(waitMs, false));
    }
}

