/*
 * Decompiled with CFR 0.152.
 */
package rsp.examples;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import rsp.App;
import rsp.Component;
import rsp.html.HtmlDsl;
import rsp.jetty.JettyServer;
import rsp.routing.Route;
import rsp.routing.RoutingDsl;
import rsp.server.HttpRequest;

public class PlainForm {
    public static void main(String[] args) {
        App<Optional<FullName>> app = new App<Optional<FullName>>((Optional<FullName>)((Object)PlainForm.route()), PlainForm.pages());
        JettyServer<Optional<FullName>> server = new JettyServer<Optional<FullName>>(8080, "", app);
        server.start();
        server.join();
    }

    private static Route<HttpRequest, Optional<FullName>> route() {
        return RoutingDsl.concat(RoutingDsl.post("/*", req -> CompletableFuture.completedFuture(Optional.of(new FullName(req.queryParam("firstname").orElseThrow(), req.queryParam("lastname").orElseThrow())))));
    }

    private static Component<Optional<FullName>> pages() {
        return s -> HtmlDsl.html(HtmlDsl.headPlain(HtmlDsl.title("Plain Form Pages")), HtmlDsl.body(((Optional)s.get()).isEmpty() ? PlainForm.formComponent().render((Optional<FullName>)((Object)s)) : PlainForm.formResult().render((Optional<FullName>)((Object)s))));
    }

    private static Component<Optional<FullName>> formComponent() {
        return s -> HtmlDsl.div(HtmlDsl.h2(HtmlDsl.text("HTML Form")), HtmlDsl.form(HtmlDsl.attr("action", "page0"), HtmlDsl.attr("method", "post"), HtmlDsl.label(HtmlDsl.attr("for", "firstname"), HtmlDsl.text("First name:")), HtmlDsl.input(HtmlDsl.attr("type", "text"), HtmlDsl.attr("name", "firstname"), HtmlDsl.attr("value", "First")), HtmlDsl.br(), HtmlDsl.label(HtmlDsl.attr("for", "lastname"), HtmlDsl.text("Last name:")), HtmlDsl.input(HtmlDsl.attr("type", "text"), HtmlDsl.attr("name", "lastname"), HtmlDsl.attr("value", "Last")), HtmlDsl.br(), HtmlDsl.input(HtmlDsl.attr("type", "submit"), HtmlDsl.attr("value", "Submit"))), HtmlDsl.p("If you click the 'Submit' button, the form-data will be sent to page0."));
    }

    private static Component<Optional<FullName>> formResult() {
        return s -> HtmlDsl.div(HtmlDsl.h2(HtmlDsl.text("HTML Form result")), HtmlDsl.div(HtmlDsl.p("The submitted name is " + ((Optional)s.get()).orElseThrow())));
    }

    public static class FullName {
        public final String firstName;
        public final String secondName;

        public FullName(String firstName, String secondName) {
            this.firstName = Objects.requireNonNull(firstName);
            this.secondName = Objects.requireNonNull(secondName);
        }

        public String toString() {
            return this.firstName + " " + this.secondName;
        }
    }
}

