/*
 * Decompiled with CFR 0.152.
 */
package rsp.dom;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public final class VirtualDomPath {
    public static final String SEPARATOR = "_";
    public static final VirtualDomPath DOCUMENT = VirtualDomPath.of("1");
    public static final VirtualDomPath WINDOW = VirtualDomPath.of("0");
    private final int[] array;

    public VirtualDomPath(int ... xs) {
        this.array = xs;
    }

    public static VirtualDomPath of(String path) {
        return new VirtualDomPath(Arrays.stream(path.split(SEPARATOR)).mapToInt(s -> Integer.parseInt(s)).toArray());
    }

    public int level() {
        return this.array.length;
    }

    public VirtualDomPath incLevel() {
        int[] a = Arrays.copyOf(this.array, this.array.length + 1);
        a[a.length - 1] = 1;
        return new VirtualDomPath(a);
    }

    public VirtualDomPath incSibling() {
        int[] a = Arrays.copyOf(this.array, this.array.length);
        int n = a.length - 1;
        a[n] = a[n] + 1;
        return new VirtualDomPath(a);
    }

    public Optional<VirtualDomPath> parent() {
        if (this.equals(WINDOW)) {
            return Optional.empty();
        }
        if (this.equals(DOCUMENT)) {
            return Optional.of(WINDOW);
        }
        return Optional.of(this.take(this.array.length - 1));
    }

    public VirtualDomPath childNumber(int num) {
        VirtualDomPath childPath = this.incLevel();
        childPath.array[childPath.level() - 1] = num;
        return childPath;
    }

    private VirtualDomPath take(int level) {
        int[] na = new int[level];
        System.arraycopy(this.array, 0, na, 0, level);
        return new VirtualDomPath(na);
    }

    public String toString() {
        if (this.array.length == 0) {
            return "";
        }
        return String.join((CharSequence)SEPARATOR, Arrays.stream(this.array).mapToObj(Integer::toString).collect(Collectors.toList()));
    }

    public boolean equals(Object other) {
        if (other instanceof VirtualDomPath) {
            return Arrays.equals(this.array, ((VirtualDomPath)other).array);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }
}

