/*
 * Decompiled with CFR 0.152.
 */
package rsp.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import rsp.dom.Attribute;
import rsp.dom.Node;
import rsp.dom.Style;
import rsp.dom.VirtualDomPath;
import rsp.dom.XmlNs;

public final class Tag
implements Node {
    public final VirtualDomPath path;
    public final XmlNs xmlns;
    public final String name;
    public final CopyOnWriteArraySet<Attribute> attributes = new CopyOnWriteArraySet();
    public final CopyOnWriteArraySet<Style> styles = new CopyOnWriteArraySet();
    public final List<Node> children = new ArrayList<Node>();

    public Tag(VirtualDomPath path, XmlNs xmlns, String name) {
        this.path = path;
        this.xmlns = xmlns;
        this.name = name;
    }

    public void addChild(Node node) {
        this.children.add(node);
    }

    public void addAttribute(String name, String value, boolean isProperty) {
        this.attributes.add(new Attribute(name, value, isProperty));
    }

    public void addStyle(String name, String value) {
        this.styles.add(new Style(name, value));
    }

    @Override
    public VirtualDomPath path() {
        return this.path;
    }

    public List<Node> children() {
        return this.children;
    }

    @Override
    public void appendString(StringBuilder sb) {
        sb.append('<');
        sb.append(this.name);
        if (this.styles.size() > 0) {
            sb.append(" style=\"");
            for (Style style : this.styles) {
                sb.append(style.name);
                sb.append(":");
                sb.append(style.value);
                sb.append(";");
            }
            sb.append('\"');
        }
        if (this.attributes.size() > 0) {
            for (Attribute attribute : this.attributes) {
                sb.append(' ');
                sb.append(attribute.name);
                sb.append('=');
                sb.append('\"');
                sb.append(attribute.value);
                sb.append('\"');
            }
        }
        sb.append('>');
        if (this.children.size() > 0) {
            for (Node childNode : this.children) {
                childNode.appendString(sb);
            }
        }
        sb.append("</");
        sb.append(this.name);
        sb.append('>');
    }
}

