/*
 * Decompiled with CFR 0.152.
 */
package rsp.dom;

import java.util.Objects;
import java.util.function.Consumer;
import rsp.dom.VirtualDomPath;
import rsp.page.EventContext;

public final class Event {
    public static final Modifier NO_MODIFIER = new NoModifier();
    public final Target eventTarget;
    public final Consumer<EventContext> eventHandler;
    public final boolean preventDefault;
    public final Modifier modifier;

    public Event(Target eventTarget, Consumer<EventContext> eventHandler, boolean preventDefault, Modifier modifier) {
        this.eventTarget = Objects.requireNonNull(eventTarget);
        this.eventHandler = Objects.requireNonNull(eventHandler);
        this.preventDefault = preventDefault;
        this.modifier = Objects.requireNonNull(modifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return this.preventDefault == event.preventDefault && Objects.equals(this.eventTarget, event.eventTarget) && Objects.equals(this.modifier, event.modifier);
    }

    public int hashCode() {
        return Objects.hash(this.eventTarget, this.preventDefault, this.modifier);
    }

    public static final class DebounceModifier
    implements Modifier {
        public final int waitMs;
        public final boolean immediate;

        public DebounceModifier(int waitMs, boolean immediate) {
            this.waitMs = waitMs;
            this.immediate = immediate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DebounceModifier that = (DebounceModifier)o;
            return this.waitMs == that.waitMs && this.immediate == that.immediate;
        }

        public int hashCode() {
            return Objects.hash(this.waitMs, this.immediate);
        }
    }

    public static final class ThrottleModifier
    implements Modifier {
        public final int timeFrameMs;

        public ThrottleModifier(int timeFrameMs) {
            this.timeFrameMs = timeFrameMs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThrottleModifier that = (ThrottleModifier)o;
            return this.timeFrameMs == that.timeFrameMs;
        }

        public int hashCode() {
            return Objects.hash(this.timeFrameMs);
        }
    }

    public static class NoModifier
    implements Modifier {
    }

    public static interface Modifier {
    }

    public static final class Target {
        public final String eventType;
        public final VirtualDomPath elementPath;

        public Target(String eventType, VirtualDomPath elementPath) {
            this.eventType = Objects.requireNonNull(eventType);
            this.elementPath = Objects.requireNonNull(elementPath);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Target target = (Target)o;
            return Objects.equals(this.eventType, target.eventType) && Objects.equals(this.elementPath, target.elementPath);
        }

        public int hashCode() {
            return Objects.hash(this.eventType, this.elementPath);
        }
    }
}

