/*
 * Decompiled with CFR 0.152.
 */
package rsp.dom;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import rsp.dom.Event;
import rsp.dom.Tag;
import rsp.dom.Text;
import rsp.dom.VirtualDomPath;
import rsp.dom.XmlNs;
import rsp.page.EventContext;
import rsp.page.PageRenderContext;
import rsp.ref.Ref;

public final class DomTreePageRenderContext
implements PageRenderContext {
    public final ConcurrentHashMap<Event.Target, Event> events = new ConcurrentHashMap();
    public final ConcurrentHashMap<Ref, VirtualDomPath> refs = new ConcurrentHashMap();
    private final Deque<Tag> tagsStack = new ArrayDeque<Tag>();
    private int statusCode;
    private Map<String, String> headers;
    private String docType;
    private Tag root;

    public Map<String, String> headers() {
        return this.headers;
    }

    public String docType() {
        return this.docType;
    }

    public Tag root() {
        return this.root;
    }

    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public void setDocType(String docType) {
        this.docType = docType;
    }

    @Override
    public void openNode(XmlNs xmlns, String name) {
        if (this.root == null) {
            this.root = new Tag(VirtualDomPath.DOCUMENT, xmlns, name);
            this.tagsStack.push(this.root);
        } else {
            Tag parent = this.tagsStack.peek();
            int nextChild = parent.children.size() + 1;
            Tag newTag = new Tag(parent.path.childNumber(nextChild), xmlns, name);
            parent.addChild(newTag);
            this.tagsStack.push(newTag);
        }
    }

    @Override
    public void closeNode(String name, boolean upgrade) {
        this.tagsStack.pop();
    }

    @Override
    public void setAttr(XmlNs xmlNs, String name, String value, boolean isProperty) {
        this.tagsStack.peek().addAttribute(name, value, isProperty);
    }

    @Override
    public void setStyle(String name, String value) {
        this.tagsStack.peek().addStyle(name, value);
    }

    @Override
    public void addTextNode(String text) {
        this.tagsStack.peek().addChild(new Text(this.tagsStack.peek().path, text));
    }

    @Override
    public void addEvent(Optional<VirtualDomPath> elementPath, String eventType, Consumer<EventContext> eventHandler, boolean preventDefault, Event.Modifier modifier) {
        VirtualDomPath eventPath = elementPath.orElse(this.tagsStack.peek().path);
        Event.Target eventTarget = new Event.Target(eventType, eventPath);
        this.events.put(eventTarget, new Event(eventTarget, eventHandler, preventDefault, modifier));
    }

    @Override
    public void addRef(Ref ref) {
        this.refs.put(ref, this.tagsStack.peek().path);
    }

    public String toString() {
        if (this.root == null) {
            throw new IllegalStateException("DOM tree not initialized");
        }
        StringBuilder sb = new StringBuilder();
        if (this.docType != null) {
            sb.append(this.docType);
        }
        this.root.appendString(sb);
        return sb.toString();
    }
}

