/*
 * Decompiled with CFR 0.152.
 */
package rsp.dom;

import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArraySet;
import rsp.dom.Attribute;
import rsp.dom.DomChangesPerformer;
import rsp.dom.Node;
import rsp.dom.Style;
import rsp.dom.Tag;
import rsp.dom.Text;
import rsp.dom.VirtualDomPath;
import rsp.dom.XmlNs;

public final class Diff {
    private final Optional<Tag> current;
    private final Tag work;
    private final DomChangesPerformer performer;

    public Diff(Optional<Tag> current, Tag work, DomChangesPerformer performer) {
        this.current = Objects.requireNonNull(current);
        this.work = Objects.requireNonNull(work);
        this.performer = Objects.requireNonNull(performer);
    }

    public void run() {
        this.current.ifPresentOrElse(current -> Diff.diff(current, this.work, new VirtualDomPath(1), this.performer), () -> Diff.create(this.work, new VirtualDomPath(1), this.performer));
    }

    private static void diff(Tag c, Tag w, VirtualDomPath path, DomChangesPerformer changesPerformer) {
        if (!c.name.equals(w.name)) {
            changesPerformer.remove(path.parent().get(), path);
            Diff.create(w, path, changesPerformer);
        } else {
            Diff.diffStyles(c.styles, w.styles, path, changesPerformer);
            Diff.diffAttributes(c.attributes, w.attributes, path, changesPerformer);
            Diff.diffChildren(c.children, w.children, path.incLevel(), changesPerformer);
        }
    }

    private static void diffAttributes(CopyOnWriteArraySet<Attribute> ca, CopyOnWriteArraySet<Attribute> wa, VirtualDomPath path, DomChangesPerformer performer) {
        CopyOnWriteArraySet<Attribute> c = new CopyOnWriteArraySet<Attribute>(ca);
        CopyOnWriteArraySet<Attribute> w = new CopyOnWriteArraySet<Attribute>(wa);
        c.removeAll(wa);
        c.forEach(attribute -> performer.removeAttr(path, XmlNs.html, attribute.name, attribute.isProperty));
        w.removeAll(ca);
        w.forEach(attribute -> performer.setAttr(path, XmlNs.html, attribute.name, attribute.value, attribute.isProperty));
    }

    private static void diffStyles(CopyOnWriteArraySet<Style> ca, CopyOnWriteArraySet<Style> wa, VirtualDomPath path, DomChangesPerformer performer) {
        CopyOnWriteArraySet<Style> c = new CopyOnWriteArraySet<Style>(ca);
        CopyOnWriteArraySet<Style> w = new CopyOnWriteArraySet<Style>(wa);
        c.removeAll(wa);
        c.forEach(attribute -> performer.removeStyle(path, attribute.name));
        w.removeAll(ca);
        w.forEach(attribute -> performer.setStyle(path, attribute.name, attribute.value));
    }

    private static void diffChildren(List<Node> cc, List<Node> wc, VirtualDomPath path, DomChangesPerformer performer) {
        ListIterator<Node> c = cc.listIterator();
        ListIterator<Node> w = wc.listIterator();
        VirtualDomPath p = path;
        while (c.hasNext() || w.hasNext()) {
            Node nc;
            if (c.hasNext() && w.hasNext()) {
                nc = c.next();
                Node nw = w.next();
                if (nc instanceof Tag && nw instanceof Tag) {
                    Diff.diff((Tag)nc, (Tag)nw, p, performer);
                } else if (nw instanceof Tag) {
                    performer.remove(nc.path().parent().get(), nc.path());
                    Diff.create((Tag)nw, path, performer);
                } else if (nc instanceof Tag) {
                    performer.remove(nc.path().parent().get(), nc.path());
                    performer.createText(path.parent().get(), path, ((Text)nw).text);
                } else if (!((Text)nc).text.equals(((Text)nw).text)) {
                    performer.createText(path.parent().get(), path, ((Text)nw).text);
                }
            } else if (c.hasNext()) {
                nc = c.next();
                performer.remove(nc.path().parent().get(), nc.path());
            } else {
                Node nw = w.next();
                Diff.create((Tag)nw, p, performer);
            }
            p = p.incSibling();
        }
    }

    private static void create(Tag tag, VirtualDomPath path, DomChangesPerformer changesPerformer) {
        changesPerformer.create(path, tag.xmlns, tag.name);
        for (Style style : tag.styles) {
            changesPerformer.setStyle(path, style.name, style.value);
        }
        for (Attribute attribute : tag.attributes) {
            changesPerformer.setAttr(path, XmlNs.html, attribute.name, attribute.value, attribute.isProperty);
        }
        VirtualDomPath p = path.incLevel();
        for (Node child : tag.children) {
            if (child instanceof Tag) {
                Tag newTag = (Tag)child;
                Diff.create(newTag, p, changesPerformer);
            } else if (child instanceof Text) {
                Text text = (Text)child;
                changesPerformer.createText(path, p, text.text);
            }
            p = p.incSibling();
        }
    }
}

