/*
 * Decompiled with CFR 0.152.
 */
package rsp.dom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import rsp.dom.DomChangesPerformer;
import rsp.dom.VirtualDomPath;
import rsp.dom.XmlNs;

public final class DefaultDomChangesPerformer
implements DomChangesPerformer {
    public final Set<VirtualDomPath> elementsToRemove = new HashSet<VirtualDomPath>();
    public final List<DomChange> commands = new ArrayList<DomChange>();

    @Override
    public void removeAttr(VirtualDomPath path, XmlNs xmlNs, String name, boolean isProperty) {
        this.commands.add(new RemoveAttr(path, xmlNs, name, isProperty));
    }

    @Override
    public void removeStyle(VirtualDomPath path, String name) {
        this.commands.add(new RemoveStyle(path, name));
    }

    @Override
    public void remove(VirtualDomPath parentPath, VirtualDomPath path) {
        this.commands.add(new Remove(parentPath, path));
        this.elementsToRemove.add(path);
    }

    @Override
    public void setAttr(VirtualDomPath path, XmlNs xmlNs, String name, String value, boolean isProperty) {
        this.commands.add(new SetAttr(path, xmlNs, name, value, isProperty));
    }

    @Override
    public void setStyle(VirtualDomPath path, String name, String value) {
        this.commands.add(new SetStyle(path, name, value));
    }

    @Override
    public void createText(VirtualDomPath parentPath, VirtualDomPath path, String text) {
        this.commands.add(new CreateText(parentPath, path, text));
    }

    @Override
    public void create(VirtualDomPath path, XmlNs xmlNs, String tag) {
        this.commands.add(new Create(path, xmlNs, tag));
    }

    public static final class Create
    implements DomChange {
        public final VirtualDomPath path;
        public final XmlNs xmlNs;
        public final String tag;

        public Create(VirtualDomPath path, XmlNs xmlNs, String tag) {
            this.path = path;
            this.xmlNs = xmlNs;
            this.tag = tag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Create create = (Create)o;
            return Objects.equals(this.path, create.path) && Objects.equals(this.xmlNs, create.xmlNs) && Objects.equals(this.tag, create.tag);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.xmlNs, this.tag);
        }
    }

    public static final class CreateText
    implements DomChange {
        public final VirtualDomPath parentPath;
        public final VirtualDomPath path;
        public final String text;

        public CreateText(VirtualDomPath parentPath, VirtualDomPath path, String text) {
            this.parentPath = parentPath;
            this.path = path;
            this.text = text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CreateText that = (CreateText)o;
            return Objects.equals(this.parentPath, that.parentPath) && Objects.equals(this.path, that.path) && Objects.equals(this.text, that.text);
        }

        public int hashCode() {
            return Objects.hash(this.parentPath, this.path, this.text);
        }

        public String toString() {
            return "CreateText{parentPath=" + this.parentPath + ", path=" + this.path + ", text='" + this.text + "'}";
        }
    }

    public static final class SetStyle
    implements DomChange {
        public final VirtualDomPath path;
        public final String name;
        public final String value;

        public SetStyle(VirtualDomPath path, String name, String value) {
            this.path = path;
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetStyle setStyle = (SetStyle)o;
            return Objects.equals(this.path, setStyle.path) && Objects.equals(this.name, setStyle.name) && Objects.equals(this.value, setStyle.value);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.name, this.value);
        }
    }

    public static final class SetAttr
    implements DomChange {
        public final VirtualDomPath path;
        public final XmlNs xmlNs;
        public final String name;
        public final String value;
        public final boolean isProperty;

        public SetAttr(VirtualDomPath path, XmlNs xmlNs, String name, String value, boolean isProperty) {
            this.path = path;
            this.xmlNs = xmlNs;
            this.name = name;
            this.value = value;
            this.isProperty = isProperty;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetAttr setAttr = (SetAttr)o;
            return this.isProperty == setAttr.isProperty && Objects.equals(this.path, setAttr.path) && Objects.equals(this.xmlNs, setAttr.xmlNs) && Objects.equals(this.name, setAttr.name) && Objects.equals(this.value, setAttr.value);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.xmlNs, this.name, this.value, this.isProperty);
        }
    }

    public static final class Remove
    implements DomChange {
        public final VirtualDomPath parentPath;
        public final VirtualDomPath path;

        public Remove(VirtualDomPath parentPath, VirtualDomPath path) {
            this.parentPath = parentPath;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Remove remove = (Remove)o;
            return Objects.equals(this.parentPath, remove.parentPath) && Objects.equals(this.path, remove.path);
        }

        public int hashCode() {
            return Objects.hash(this.parentPath, this.path);
        }
    }

    public static final class RemoveStyle
    implements DomChange {
        public final VirtualDomPath path;
        public final String name;

        public RemoveStyle(VirtualDomPath path, String name) {
            this.path = path;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveStyle that = (RemoveStyle)o;
            return Objects.equals(this.path, that.path) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.name);
        }
    }

    public static final class RemoveAttr
    implements DomChange {
        public final VirtualDomPath path;
        public final XmlNs xmlNs;
        public final String name;
        public final boolean isProperty;

        public RemoveAttr(VirtualDomPath path, XmlNs xmlNs, String name, boolean isProperty) {
            this.path = path;
            this.xmlNs = xmlNs;
            this.name = name;
            this.isProperty = isProperty;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveAttr that = (RemoveAttr)o;
            return this.isProperty == that.isProperty && Objects.equals(this.path, that.path) && Objects.equals(this.xmlNs, that.xmlNs) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.xmlNs, this.name, this.isProperty);
        }
    }

    public static interface DomChange {
    }
}

