/*
 * Decompiled with CFR 0.152.
 */
package rsp;

import rsp.util.logging.Log;

public final class AppConfig {
    public static final String LOG_LEVEL_PROPERTY_NAME = "rsp.log.level";
    public static final Log.Level DEFAULT_LOG_LEVEL = Log.Level.INFO;
    public static final Log.Reporting DEFAULT_CONSOLE_LOG = new Log.Default(Log.Level.valueOf(System.getProperty("rsp.log.level", DEFAULT_LOG_LEVEL.name()).toUpperCase()), new Log.SimpleFormat(), string -> System.out.println((String)string));
    public static final int DEFAULT_HEARTBEAT_INTERVAL_MS = 10000;
    public static final int DEFAULT_SCHEDULER_THREAD_POOL_SIZE = 10;
    public static AppConfig DEFAULT = new AppConfig(10000, 10, DEFAULT_CONSOLE_LOG);
    public final int heartbeatIntervalMs;
    public final int schedulerThreadPoolSize;
    public final Log.Reporting log;

    public AppConfig(int heartbeatIntervalMs, int schedulerThreadPoolSize, Log.Reporting log) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        this.schedulerThreadPoolSize = schedulerThreadPoolSize;
        this.log = log;
    }

    public AppConfig heartbeatIntervalMs(int heartbeatIntervalMs) {
        return new AppConfig(heartbeatIntervalMs, this.schedulerThreadPoolSize, this.log);
    }

    public AppConfig log(Log.Reporting log) {
        return new AppConfig(this.heartbeatIntervalMs, this.schedulerThreadPoolSize, log);
    }
}

