/*
 * Decompiled with CFR 0.152.
 */
package rsp;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import rsp.AppConfig;
import rsp.Component;
import rsp.page.PageLifeCycle;
import rsp.page.PageRendering;
import rsp.page.QualifiedSessionId;
import rsp.routing.Route;
import rsp.server.HttpRequest;
import rsp.server.Path;

public final class App<S> {
    public final AppConfig config;
    public final Route<HttpRequest, S> routes;
    public final BiFunction<S, Path, Path> state2path;
    public final PageLifeCycle<S> lifeCycleEventsListener;
    public final Component<S> rootComponent;
    public final Map<QualifiedSessionId, PageRendering.RenderedPage<S>> pagesStorage = new ConcurrentHashMap<QualifiedSessionId, PageRendering.RenderedPage<S>>();

    private App(AppConfig config, BiFunction<S, Path, Path> state2path, PageLifeCycle<S> lifeCycleEventsListener, Route<HttpRequest, S> routes, Component<S> rootComponent) {
        this.config = config;
        this.routes = routes;
        this.state2path = state2path;
        this.lifeCycleEventsListener = lifeCycleEventsListener;
        this.rootComponent = rootComponent;
    }

    public App(Route<HttpRequest, S> routes, Component<S> rootComponent) {
        this(AppConfig.DEFAULT, (s, p) -> p, new PageLifeCycle.Default(), routes, rootComponent);
    }

    public App(S initialState, Component<S> rootComponent) {
        this(AppConfig.DEFAULT, (s, p) -> p, new PageLifeCycle.Default(), request -> Optional.of(CompletableFuture.completedFuture(initialState)), rootComponent);
    }

    public App<S> config(AppConfig config) {
        return new App<S>(config, this.state2path, this.lifeCycleEventsListener, this.routes, this.rootComponent);
    }

    public App<S> stateToPath(BiFunction<S, Path, Path> stateToPath) {
        return new App<S>(this.config, stateToPath, this.lifeCycleEventsListener, this.routes, this.rootComponent);
    }

    public App<S> pageLifeCycle(PageLifeCycle<S> lifeCycleEventsListener) {
        return new App<S>(this.config, this.state2path, lifeCycleEventsListener, this.routes, this.rootComponent);
    }
}

