/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.util.Comparator;
import java.util.List;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.blueprint.ModelBoundingBox;
import kr.toxicity.model.api.manager.ConfigManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class EntityUtil {
    public static final double RENDER_DISTANCE = Bukkit.getViewDistance() << 3;
    public static final float ENTITY_MODEL_VIEW_RADIUS = (float)Bukkit.getViewDistance() / 4.0f;
    private static final double Y_RENDER_THRESHOLD = Math.toRadians(45.0);
    private static final double X_RENDER_THRESHOLD = Y_RENDER_THRESHOLD * 1.78;

    private EntityUtil() {
        throw new RuntimeException();
    }

    public static boolean canSee(@NotNull Location player, @NotNull Location target) {
        ConfigManager manager = BetterModel.inst().configManager();
        if (!manager.sightTrace()) {
            return true;
        }
        if (player.getWorld() != target.getWorld()) {
            return false;
        }
        double d = player.distance(target);
        if (d > manager.maxSight()) {
            return false;
        }
        if (d <= manager.minSight()) {
            return true;
        }
        double playerYaw = Math.toRadians(player.getYaw());
        double playerPitch = -Math.toRadians(player.getPitch());
        double dz = target.getZ() - player.getZ();
        double dy = target.getY() - player.getY();
        double dx = target.getX() - player.getX();
        double r = Math.cos(playerYaw) * dz - Math.sin(playerYaw) * dx;
        double ry = Math.abs(Math.atan2(dy, Math.abs(r)) - playerPitch);
        double rz = Math.abs(Math.atan2(-dx, dz) - playerYaw);
        double t = Math.PI - Math.abs(Math.atan(d)) * 2.0;
        double ty = t + Y_RENDER_THRESHOLD;
        double tz = t + X_RENDER_THRESHOLD;
        return (ry <= ty || ry >= Math.PI * 2 - ty) && (rz <= tz || rz >= Math.PI * 2 - tz);
    }

    @Nullable
    public static ModelBoundingBox max(@NotNull List<ModelBoundingBox> target) {
        return target.stream().max(Comparator.comparingDouble(ModelBoundingBox::length)).orElse(null);
    }
}

