/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Objects;
import java.util.function.Supplier;
import kr.toxicity.model.api.util.EntityUtil;
import kr.toxicity.model.api.util.FunctionUtil;
import org.jetbrains.annotations.NotNull;

public record TrackerModifier(@NotNull Supplier<Float> scale, boolean sightTrace, boolean damageEffect, float viewRange, boolean shadow) {
    public static final TrackerModifier DEFAULT = new TrackerModifier(FunctionUtil.asSupplier(Float.valueOf(1.0f)), true, true, EntityUtil.ENTITY_MODEL_VIEW_RADIUS, true);

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Supplier<Float> scale;
        private boolean sightTrace;
        private boolean damageEffect;
        private float viewRange;
        private boolean shadow;

        private Builder() {
            this.scale = TrackerModifier.DEFAULT.scale;
            this.sightTrace = TrackerModifier.DEFAULT.sightTrace;
            this.damageEffect = TrackerModifier.DEFAULT.damageEffect;
            this.viewRange = TrackerModifier.DEFAULT.viewRange;
            this.shadow = TrackerModifier.DEFAULT.shadow;
        }

        @NotNull
        public Builder scale(@NotNull Supplier<Float> scale) {
            this.scale = Objects.requireNonNull(scale, "scale cannot be null.");
            return this;
        }

        @NotNull
        public Builder sightTrace(boolean sightTrace) {
            this.sightTrace = sightTrace;
            return this;
        }

        @NotNull
        public Builder damageEffect(boolean damageEffect) {
            this.damageEffect = damageEffect;
            return this;
        }

        @NotNull
        public Builder viewRange(float viewRange) {
            this.viewRange = viewRange;
            return this;
        }

        @NotNull
        public Builder shadow(boolean shadow) {
            this.shadow = shadow;
            return this;
        }

        @NotNull
        public TrackerModifier build() {
            return new TrackerModifier(this.scale, this.sightTrace, this.damageEffect, this.viewRange, this.shadow);
        }
    }
}

