/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Objects;
import java.util.UUID;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.renderer.RenderInstance;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.event.CreateDummyTrackerEvent;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.FunctionUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public final class DummyTracker
extends Tracker {
    private Location location;
    private UUID uuid = UUID.randomUUID();

    public DummyTracker(@NotNull RenderSource.Located source, @NotNull RenderInstance instance, @NotNull TrackerModifier modifier) {
        super(source, instance, modifier);
        this.location = source.location();
        instance.animate("spawn");
        instance.scale(modifier.scale());
        this.rotation(() -> new ModelRotation(0.0f, this.location.getYaw()));
        instance.defaultPosition(FunctionUtil.asSupplier(new Vector3f()));
        this.update();
        EventUtil.call(new CreateDummyTrackerEvent(this));
    }

    public void location(@NotNull Location location) {
        this.location = Objects.requireNonNull(location, "location");
        PacketBundler bundler = BetterModel.inst().nms().createBundler(this.instance.getDisplayAmount(), false);
        this.instance.teleport(location, bundler);
        if (!bundler.isEmpty()) {
            this.instance.allPlayer().map(PlayerChannelHandler::player).forEach(bundler::send);
        }
    }

    @Override
    @NotNull
    public UUID uuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    public Location location() {
        return this.location;
    }

    public void spawn(@NotNull Player player) {
        PacketBundler bundler = this.instance.createBundler();
        this.spawn(player, bundler);
        bundler.send(player);
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }
}

