/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.player;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.util.function.Consumer;
import java.util.function.Function;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.util.TransformedItemStack;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public enum PlayerLimb {
    HEAD(PlayerLimb.position(0), PlayerLimb.scale(7.4688f, 0.5f), PlayerLimb.scale(7.4688f, 0.5f), PlayerLimb.offset(0.0f, 7.5f, 0.0f, 0.5f), PlayerLimb.offset(0.0f, 7.5f, 0.0f, 0.5f), ItemDisplay.ItemDisplayTransform.FIXED),
    RIGHT_ARM(PlayerLimb.position(1), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(2.7891f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(-0.625f, 1.5f, 0.0f, 0.25f), PlayerLimb.offset(-0.043f, 1.5f, 0.0f, 0.25f), ItemDisplay.ItemDisplayTransform.FIXED),
    RIGHT_FOREARM(PlayerLimb.position(2), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(2.7891f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(-0.625f, 1.5f, 0.0f, 0.25f), PlayerLimb.offset(-0.043f, 1.5f, 0.0f, 0.25f), ItemDisplay.ItemDisplayTransform.FIXED),
    LEFT_ARM(PlayerLimb.position(3), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(2.7891f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(0.625f, 1.5f, 0.0f, 0.25f), PlayerLimb.offset(0.043f, 1.5f, 0.0f, 0.25f), ItemDisplay.ItemDisplayTransform.FIXED),
    LEFT_FOREARM(PlayerLimb.position(4), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(2.7891f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(0.625f, 1.5f, 0.0f, 0.25f), PlayerLimb.offset(0.043f, 1.5f, 0.0f, 0.25f), ItemDisplay.ItemDisplayTransform.FIXED),
    HIP(PlayerLimb.position(5), PlayerLimb.scale(7.4688f, 3.7188f, 3.7188f, 0.25f), PlayerLimb.scale(7.4688f, 3.7188f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 5.75f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 5.75f, 0.0f, 0.25f), ItemDisplay.ItemDisplayTransform.FIXED),
    WAIST(PlayerLimb.position(6), PlayerLimb.scale(7.4688f, 3.7188f, 3.7188f, 0.25f), PlayerLimb.scale(7.4688f, 3.7188f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 5.75f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 5.75f, 0.0f, 0.25f), ItemDisplay.ItemDisplayTransform.FIXED),
    CHEST(PlayerLimb.position(7), PlayerLimb.scale(7.4688f, 3.7188f, 3.7188f, 0.25f), PlayerLimb.scale(7.4688f, 3.7188f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 5.75f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 5.75f, 0.0f, 0.25f), ItemDisplay.ItemDisplayTransform.FIXED),
    RIGHT_LEG(PlayerLimb.position(8), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), ItemDisplay.ItemDisplayTransform.FIXED),
    RIGHT_FORELEG(PlayerLimb.position(9), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), ItemDisplay.ItemDisplayTransform.FIXED),
    LEFT_LEG(PlayerLimb.position(10), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), ItemDisplay.ItemDisplayTransform.FIXED),
    LEFT_FORELEG(PlayerLimb.position(11), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), ItemDisplay.ItemDisplayTransform.FIXED),
    LEFT_ITEM(new Vector3f(), new Vector3f(1.0f), new Vector3f(1.0f), new Vector3f(), new Vector3f(), ItemDisplay.ItemDisplayTransform.THIRDPERSON_LEFTHAND){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public TransformedItemStack createItem(@NotNull RenderSource.Profiled profiled) {
            Player entity;
            TransformedItemStack transformedItemStack;
            if (!(profiled instanceof RenderSource.BasePlayer)) {
                transformedItemStack = TransformedItemStack.empty();
                return transformedItemStack;
            }
            RenderSource.BasePlayer basePlayer = (RenderSource.BasePlayer)profiled;
            try {
                Player player;
                entity = player = basePlayer.entity();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            transformedItemStack = TransformedItemStack.of(entity.getInventory().getItemInOffHand());
            return transformedItemStack;
        }
    }
    ,
    RIGHT_ITEM(new Vector3f(), new Vector3f(1.0f), new Vector3f(1.0f), new Vector3f(), new Vector3f(), ItemDisplay.ItemDisplayTransform.THIRDPERSON_RIGHTHAND){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public TransformedItemStack createItem(@NotNull RenderSource.Profiled profiled) {
            Player entity;
            TransformedItemStack transformedItemStack;
            if (!(profiled instanceof RenderSource.BasePlayer)) {
                transformedItemStack = TransformedItemStack.empty();
                return transformedItemStack;
            }
            RenderSource.BasePlayer basePlayer = (RenderSource.BasePlayer)profiled;
            try {
                Player player;
                entity = player = basePlayer.entity();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            transformedItemStack = TransformedItemStack.of(entity.getInventory().getItemInMainHand());
            return transformedItemStack;
        }
    };

    @NotNull
    private final Vector3f position;
    @NotNull
    private final Vector3f scale;
    @NotNull
    private final Vector3f slimScale;
    @NotNull
    private final Vector3f offset;
    @NotNull
    private final Vector3f slimOffset;
    @NotNull
    private final ItemDisplay.ItemDisplayTransform transform;
    @NotNull
    private final LimbItemMapper mapper = new LimbItemMapper(this::createItem);

    @NotNull
    private static Vector3f position(int mul) {
        return new Vector3f(0.0f, -512.0f, 0.0f).mul((float)mul);
    }

    @NotNull
    private static Vector3f scale(float scale, float inflate) {
        return PlayerLimb.scale(scale, scale, scale, inflate);
    }

    @NotNull
    private static Vector3f scale(float x, float y, float z, float inflate) {
        return new Vector3f(x, y, z).div(8.0f).add((Vector3fc)new Vector3f(inflate).div(8.0f));
    }

    @NotNull
    private static Vector3f offset(float x, float y, float z, float inflate) {
        return new Vector3f(0.0f, -0.25f, 0.0f).add((Vector3fc)new Vector3f(x, y, z).div(16.0f)).add((Vector3fc)new Vector3f(0.0f, inflate, 0.0f).div(32.0f));
    }

    @NotNull
    public TransformedItemStack createItem(@NotNull RenderSource.Profiled profiled) {
        boolean isSlim = profiled.slim();
        return TransformedItemStack.of(this.position, isSlim ? this.slimOffset : this.offset, isSlim ? this.slimScale : this.scale, BetterModel.inst().nms().createPlayerHead(profiled.profile()));
    }

    @NotNull
    private TransformedItemStack createItem(@NotNull PlayerProfile profile, boolean isSlim) {
        return TransformedItemStack.of(this.position, isSlim ? this.slimOffset : this.offset, isSlim ? this.slimScale : this.scale, PlayerLimb.createSkull(meta -> meta.setPlayerProfile(profile)));
    }

    private boolean isSlim(@NotNull PlayerTextures.SkinModel skinModel) {
        return skinModel == PlayerTextures.SkinModel.SLIM;
    }

    @NotNull
    private static ItemStack createSkull(@NotNull Consumer<SkullMeta> consumer) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta meta = item.getItemMeta();
        consumer.accept((SkullMeta)meta);
        item.setItemMeta(meta);
        return item;
    }

    @Generated
    private PlayerLimb(@NotNull Vector3f position, @NotNull Vector3f scale, @NotNull Vector3f slimScale, @NotNull Vector3f offset, Vector3f slimOffset, ItemDisplay.ItemDisplayTransform transform) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (scale == null) {
            throw new NullPointerException("scale is marked non-null but is null");
        }
        if (slimScale == null) {
            throw new NullPointerException("slimScale is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        if (slimOffset == null) {
            throw new NullPointerException("slimOffset is marked non-null but is null");
        }
        if (transform == null) {
            throw new NullPointerException("transform is marked non-null but is null");
        }
        this.position = position;
        this.scale = scale;
        this.slimScale = slimScale;
        this.offset = offset;
        this.slimOffset = slimOffset;
        this.transform = transform;
    }

    @NotNull
    @Generated
    public Vector3f getPosition() {
        return this.position;
    }

    @NotNull
    @Generated
    public Vector3f getScale() {
        return this.scale;
    }

    @NotNull
    @Generated
    public Vector3f getSlimScale() {
        return this.slimScale;
    }

    @NotNull
    @Generated
    public Vector3f getOffset() {
        return this.offset;
    }

    @NotNull
    @Generated
    public Vector3f getSlimOffset() {
        return this.slimOffset;
    }

    @NotNull
    @Generated
    public ItemDisplay.ItemDisplayTransform getTransform() {
        return this.transform;
    }

    @NotNull
    @Generated
    public LimbItemMapper getMapper() {
        return this.mapper;
    }

    public class LimbItemMapper
    implements BoneItemMapper {
        private final Function<RenderSource.Profiled, TransformedItemStack> playerMapper;

        @Override
        @NotNull
        public ItemDisplay.ItemDisplayTransform transform() {
            return PlayerLimb.this.transform;
        }

        @Override
        @NotNull
        public TransformedItemStack apply(RenderSource source, TransformedItemStack transformedItemStack) {
            if (source instanceof RenderSource.Profiled) {
                RenderSource.Profiled profiled = (RenderSource.Profiled)source;
                return this.playerMapper.apply(profiled);
            }
            return transformedItemStack;
        }

        @NotNull
        public LimbItemMapper profile(@NotNull PlayerProfile profile, @NotNull PlayerTextures.SkinModel model) {
            return PlayerLimb.this.transform == ItemDisplay.ItemDisplayTransform.FIXED ? new LimbItemMapper(p -> PlayerLimb.this.createItem(profile, PlayerLimb.this.isSlim(model))) : this;
        }

        @Generated
        public LimbItemMapper(Function<RenderSource.Profiled, TransformedItemStack> playerMapper) {
            this.playerMapper = playerMapper;
        }
    }
}

