/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.Objects;
import java.util.function.Predicate;
import kr.toxicity.model.api.bone.RenderedBone;
import org.jetbrains.annotations.NotNull;

public interface AnimationPredicate
extends Predicate<RenderedBone> {
    public boolean isChildren();

    @NotNull
    public static AnimationPredicate of(@NotNull Predicate<RenderedBone> bonePredicate) {
        return AnimationPredicate.of(false, bonePredicate);
    }

    @NotNull
    public static AnimationPredicate of(final boolean children, final @NotNull Predicate<RenderedBone> bonePredicate) {
        Objects.requireNonNull(bonePredicate, "bonePredicate cannot be null.");
        return new AnimationPredicate(){

            @Override
            public boolean isChildren() {
                return children;
            }

            @Override
            public boolean test(RenderedBone renderedBone) {
                return bonePredicate.test(renderedBone);
            }
        };
    }

    @NotNull
    default public AnimationPredicate children() {
        return this.isChildren() ? this : AnimationPredicate.of(true, this);
    }
}

