/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kr.toxicity.model.api.BetterModelPlugin;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.event.PluginEndReloadEvent;
import kr.toxicity.model.api.event.PluginStartReloadEvent;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.ReflectionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class BetterModel {
    public static final boolean IS_FOLIA = ReflectionUtil.classExists("io.papermc.paper.threadedregions.RegionizedServer");
    public static final boolean IS_PURPUR = ReflectionUtil.classExists("org.purpurmc.purpur.PurpurConfig");
    public static final boolean IS_PAPER = IS_PURPUR || IS_FOLIA || ReflectionUtil.classExists("io.papermc.paper.configuration.PaperConfigurations");
    private static BetterModelPlugin instance;

    private BetterModel() {
        throw new RuntimeException();
    }

    @NotNull
    public static Optional<ModelRenderer> model(@NotNull String name) {
        return Optional.ofNullable(BetterModel.inst().modelManager().renderer(name));
    }

    @NotNull
    public static Optional<ModelRenderer> limb(@NotNull String name) {
        return Optional.ofNullable(BetterModel.inst().playerManager().limb(name));
    }

    @NotNull
    public static @Unmodifiable List<ModelRenderer> models() {
        return BetterModel.inst().modelManager().renderers();
    }

    @NotNull
    public static @Unmodifiable List<ModelRenderer> limbs() {
        return BetterModel.inst().playerManager().limbs();
    }

    @NotNull
    public static BetterModelPlugin inst() {
        return Objects.requireNonNull(instance, "BetterModel hasn't been initialized yet!");
    }

    @ApiStatus.Internal
    public static void inst(@NotNull BetterModelPlugin instance) {
        if (BetterModel.instance != null) {
            throw new RuntimeException();
        }
        instance.addReloadStartHandler(() -> EventUtil.call(new PluginStartReloadEvent()));
        instance.addReloadEndHandler(t -> EntityTracker.reload());
        instance.addReloadEndHandler(t -> EventUtil.call(new PluginEndReloadEvent((BetterModelPlugin.ReloadResult)t)));
        BetterModel.instance = Objects.requireNonNull(instance);
    }
}

