/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.reflection.method;

import io.github.portlek.reflection.RefMethod;
import io.github.portlek.reflection.RefMethodExecuted;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodOf
implements RefMethod {
    @NotNull
    private final Method method;

    @Override
    @NotNull
    public RefMethodExecuted of(@Nullable Object object) {
        return new MethodExecuted(this.method, object);
    }

    @Override
    public <A extends Annotation> Optional<A> annotation(@NotNull Class<A> annotationClass) {
        return Optional.ofNullable(this.method.getDeclaredAnnotation(annotationClass));
    }

    public MethodOf(@NotNull Method method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        this.method = method;
    }

    private static final class MethodExecuted
    implements RefMethodExecuted {
        @NotNull
        private final Method method;
        @Nullable
        private final Object object;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Optional<Object> call(Object ... parameters) {
            boolean accessible = this.method.isAccessible();
            this.method.setAccessible(true);
            try {
                Optional<Object> optional = Optional.ofNullable(this.method.invoke(this.object, parameters));
                this.method.setAccessible(accessible);
                return optional;
            }
            catch (Throwable throwable) {
                this.method.setAccessible(accessible);
                throw throwable;
            }
        }

        public MethodExecuted(@NotNull Method method, @Nullable Object object) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            this.method = method;
            this.object = object;
        }
    }
}

