/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.reflection.method;

import io.github.portlek.reflection.RefMethod;
import io.github.portlek.reflection.RefMethodExecuted;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodOf
implements RefMethod {
    private static final Logger log = Logger.getLogger(MethodOf.class.getName());
    @NotNull
    private final Method method;

    public MethodOf(@NotNull Method method) {
        this.method = method;
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(@NotNull Class<A> annotationClass) {
        return Optional.ofNullable(this.method.getDeclaredAnnotation(annotationClass));
    }

    @Override
    @NotNull
    public String getName() {
        return this.method.getName();
    }

    @Override
    @NotNull
    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    @Override
    @NotNull
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    @NotNull
    public RefMethodExecuted of(@Nullable Object object) {
        return new MethodExecuted(object);
    }

    @Override
    public boolean hasFinal() {
        return Modifier.isFinal(this.method.getModifiers());
    }

    @Override
    public boolean hasPrivate() {
        return Modifier.isPrivate(this.method.getModifiers());
    }

    @Override
    public boolean hasPublic() {
        return Modifier.isPublic(this.method.getModifiers());
    }

    @Override
    public boolean hasStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    private final class MethodExecuted
    implements RefMethodExecuted {
        @Nullable
        private final Object object;

        MethodExecuted(Object object) {
            this.object = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Optional<Object> call(Object ... parameters) {
            boolean accessible = MethodOf.this.method.isAccessible();
            try {
                MethodOf.this.method.setAccessible(true);
                Optional<Object> optional = Optional.ofNullable(MethodOf.this.method.invoke(this.object, parameters));
                return optional;
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                log.log(Level.SEVERE, "MethodExecuted#call(Object[])", exception);
                Optional<Object> optional = Optional.empty();
                return optional;
            }
            finally {
                MethodOf.this.method.setAccessible(accessible);
            }
        }
    }
}

