/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.reflection;

import io.github.portlek.reflection.RefAnnotated;
import io.github.portlek.reflection.RefConstructed;
import io.github.portlek.reflection.RefField;
import io.github.portlek.reflection.RefMethod;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public interface RefClass<T>
extends RefAnnotated {
    @NotNull
    default public <A extends Annotation> List<RefField> getFieldsWithAnnotation(@NotNull Class<A> annotationClass) {
        return this.getFields().stream().filter(refField -> refField.hasAnnotation(annotationClass)).collect(Collectors.toList());
    }

    default public <A extends Annotation> void getFieldsWithAnnotation(@NotNull Class<A> annotationClass, @NotNull BiConsumer<RefField, A> consumer) {
        this.getFields().forEach(refField -> refField.getAnnotation(annotationClass, a -> consumer.accept((RefField)refField, (Object)a)));
    }

    @NotNull
    default public <A extends Annotation> List<RefField> getDeclaredFieldsWithAnnotation(@NotNull Class<A> annotationClass) {
        return this.getDeclaredFields().stream().filter(refField -> refField.hasAnnotation(annotationClass)).collect(Collectors.toList());
    }

    default public <A extends Annotation> void getDeclaredFieldsWithAnnotation(@NotNull Class<A> annotationClass, @NotNull BiConsumer<RefField, A> consumer) {
        this.getDeclaredFields().forEach(refField -> refField.getAnnotation(annotationClass, a -> consumer.accept((RefField)refField, (Object)a)));
    }

    @NotNull
    default public <A extends Annotation> List<RefMethod> getMethodsWithAnnotation(@NotNull Class<A> annotationClass) {
        return this.getMethods().stream().filter(refField -> refField.hasAnnotation(annotationClass)).collect(Collectors.toList());
    }

    default public <A extends Annotation> void getMethodsWithAnnotation(@NotNull Class<A> annotationClass, @NotNull BiConsumer<RefMethod, A> consumer) {
        this.getMethods().forEach(refField -> refField.getAnnotation(annotationClass, a -> consumer.accept((RefMethod)refField, (Object)a)));
    }

    @NotNull
    default public <A extends Annotation> List<RefMethod> getDeclaredMethodsWithAnnotation(@NotNull Class<A> annotationClass) {
        return this.getDeclaredMethods().stream().filter(refMethod -> refMethod.hasAnnotation(annotationClass)).collect(Collectors.toList());
    }

    default public <A extends Annotation> void getDeclaredMethodsWithAnnotation(@NotNull Class<A> annotationClass, @NotNull BiConsumer<RefMethod, A> consumer) {
        this.getDeclaredMethods().forEach(refField -> refField.getAnnotation(annotationClass, a -> consumer.accept((RefMethod)refField, (Object)a)));
    }

    @NotNull
    public Class<T> getRealClass();

    public boolean isInstance(@NotNull Object var1);

    @NotNull
    public Optional<RefMethod> getPrimitiveMethod(@NotNull String var1, Object ... var2);

    @NotNull
    public Optional<RefMethod> getMethod(@NotNull String var1, Object ... var2);

    @NotNull
    public Optional<RefMethod> getPrimitiveMethodByParameter(Object ... var1);

    @NotNull
    public Optional<RefMethod> getMethodByParameter(Object ... var1);

    @NotNull
    public Optional<RefMethod> getMethodByName(String ... var1);

    @NotNull
    public <X> Optional<RefMethod> getMethodByReturnType(@NotNull RefClass<X> var1);

    @NotNull
    public Optional<RefMethod> getMethodByReturnType(@NotNull Class<?> var1);

    @NotNull
    public Optional<RefConstructed<T>> getPrimitiveConstructor(Object ... var1);

    @NotNull
    public Optional<RefConstructed<T>> getConstructor(Object ... var1);

    @NotNull
    public Optional<RefConstructed<T>> getConstructor(int var1);

    @NotNull
    public Optional<RefField> getField(@NotNull String var1);

    @NotNull
    public <X> Optional<RefField> getField(@NotNull RefClass<X> var1);

    @NotNull
    public Optional<RefField> getField(@NotNull Class<?> var1);

    @NotNull
    public List<RefField> getFields();

    @NotNull
    public List<RefField> getDeclaredFields();

    @NotNull
    public List<RefMethod> getMethods();

    @NotNull
    public List<RefMethod> getDeclaredMethods();
}

