/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.reflection;

import io.github.portlek.reflection.RefAnnotated;
import io.github.portlek.reflection.RefConstructed;
import io.github.portlek.reflection.RefField;
import io.github.portlek.reflection.RefMethod;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public interface RefClass<T>
extends RefAnnotated {
    @NotNull
    default public <A extends Annotation> List<RefField> fieldsWithAnnotation(@NotNull Class<A> annotationClass) {
        return this.fields().stream().filter(refField -> refField.hasAnnotation(annotationClass)).collect(Collectors.toList());
    }

    @NotNull
    default public <A extends Annotation> void fieldsWithAnnotation(@NotNull Class<A> annotationClass, @NotNull BiConsumer<RefField, A> consumer) {
        this.fields().forEach(refField -> refField.annotation(annotationClass, a -> consumer.accept((RefField)refField, (Object)a)));
    }

    @NotNull
    default public <A extends Annotation> List<RefField> declaredFieldsWithAnnotation(@NotNull Class<A> annotationClass) {
        return this.declaredFields().stream().filter(refField -> refField.hasAnnotation(annotationClass)).collect(Collectors.toList());
    }

    @NotNull
    default public <A extends Annotation> void declaredFieldsWithAnnotation(@NotNull Class<A> annotationClass, @NotNull BiConsumer<RefField, A> consumer) {
        this.declaredFields().forEach(refField -> refField.annotation(annotationClass, a -> consumer.accept((RefField)refField, (Object)a)));
    }

    @NotNull
    default public <A extends Annotation> List<RefMethod> methodsWithAnnotation(@NotNull Class<A> annotationClass) {
        return this.methods().stream().filter(refField -> refField.hasAnnotation(annotationClass)).collect(Collectors.toList());
    }

    @NotNull
    default public <A extends Annotation> void methodsWithAnnotation(@NotNull Class<A> annotationClass, @NotNull BiConsumer<RefMethod, A> consumer) {
        this.methods().forEach(refField -> refField.annotation(annotationClass, a -> consumer.accept((RefMethod)refField, (Object)a)));
    }

    @NotNull
    default public <A extends Annotation> List<RefMethod> declaredMethodsWithAnnotation(@NotNull Class<A> annotationClass) {
        return this.declaredMethods().stream().filter(refMethod -> refMethod.hasAnnotation(annotationClass)).collect(Collectors.toList());
    }

    @NotNull
    default public <A extends Annotation> void declaredMethodsWithAnnotation(@NotNull Class<A> annotationClass, @NotNull BiConsumer<RefMethod, A> consumer) {
        this.declaredMethods().forEach(refField -> refField.annotation(annotationClass, a -> consumer.accept((RefMethod)refField, (Object)a)));
    }

    @NotNull
    public Class<T> realClass();

    public boolean isInstance(@NotNull Object var1);

    @NotNull
    public Optional<RefMethod> primitiveMethod(@NotNull String var1, Object ... var2);

    @NotNull
    public Optional<RefMethod> method(@NotNull String var1, Object ... var2);

    @NotNull
    public Optional<RefMethod> primitiveMethodByParameter(Object ... var1);

    @NotNull
    public Optional<RefMethod> methodByParameter(Object ... var1);

    @NotNull
    public Optional<RefMethod> methodByName(String ... var1);

    @NotNull
    public <X> Optional<RefMethod> methodByReturnType(@NotNull RefClass<X> var1);

    @NotNull
    public Optional<RefMethod> methodByReturnType(@NotNull Class<?> var1);

    @NotNull
    public Optional<RefConstructed<T>> primitiveConstructor(Object ... var1);

    @NotNull
    public Optional<RefConstructed<T>> constructor(Object ... var1);

    @NotNull
    public Optional<RefConstructed<T>> constructor(int var1);

    @NotNull
    public Optional<RefField> field(@NotNull String var1);

    @NotNull
    public <X> Optional<RefField> field(@NotNull RefClass<X> var1);

    @NotNull
    public Optional<RefField> field(@NotNull Class<?> var1);

    @NotNull
    public List<RefField> fields();

    @NotNull
    public List<RefField> declaredFields();

    @NotNull
    public List<RefMethod> methods();

    @NotNull
    public List<RefMethod> declaredMethods();
}

